/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.einsteinai.internal.helpers;

import com.mulesoft.connector.einsteinai.internal.error.EinsteinErrorType;
import com.mulesoft.connector.einsteinai.internal.helpers.ThrowingFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHelper.class);

    private HttpRequestHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static String readResponseStream(InputStream inputStream) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String responseLine;
            StringBuilder response = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
            String string = response.toString();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readErrorStream(InputStream errorStream) {
        if (errorStream == null) {
            return "No error details available.";
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));){
            String line;
            StringBuilder errorResponse = new StringBuilder();
            while ((line = br.readLine()) != null) {
                errorResponse.append(line.trim());
            }
            String string = errorResponse.toString();
            return string;
        }
        catch (IOException e) {
            log.debug("Error reading error stream", (Throwable)e);
            return "Unable to get response from Einstein. Could not read reading error details as well.";
        }
    }

    public static InputStream handleHttpResponse(HttpResponse httpResponse, EinsteinErrorType errorType) {
        int responseCode = httpResponse.getStatusCode();
        if (responseCode == 200) {
            if (httpResponse.getEntity().getContent() == null) {
                throw new ModuleException("Error: No response received from Einstein", (ErrorTypeDefinition)errorType);
            }
            return httpResponse.getEntity().getContent();
        }
        if (responseCode == 401) {
            throw new AccessTokenExpiredException();
        }
        String errorMessage = HttpRequestHelper.readErrorStream(httpResponse.getEntity().getContent());
        log.info("Error in HTTP request. Response code: {}, message: {}", (Object)responseCode, (Object)errorMessage);
        throw new ModuleException(String.format("Error in HTTP request. ErrorCode: %d , ErrorMessage: %s", responseCode, errorMessage), (ErrorTypeDefinition)errorType);
    }

    public static <A> void handleHttpResponse(HttpResponse httpResponse, Throwable exception, EinsteinErrorType einsteinErrorType, CompletionCallback<InputStream, A> callback, ThrowingFunction<InputStream, Result<InputStream, A>> responseConverter) {
        if (exception != null) {
            callback.error(exception);
            return;
        }
        InputStream contentStream = HttpRequestHelper.parseHttpResponse(httpResponse, einsteinErrorType, callback);
        if (contentStream == null) {
            return;
        }
        try {
            callback.success(responseConverter.apply(contentStream));
        }
        catch (IOException e) {
            callback.error((Throwable)e);
        }
    }

    public static String handleHttpResponseForTools(HttpResponse httpResponse) throws IOException {
        InputStream responseStream = httpResponse.getEntity().getContent();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(responseStream, StandardCharsets.UTF_8));){
            String inputLine;
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            String string = response.toString();
            return string;
        }
    }

    private static InputStream parseHttpResponse(HttpResponse httpResponse, EinsteinErrorType einsteinErrorType, CompletionCallback callback) {
        int statusCode = httpResponse.getStatusCode();
        log.debug("Parsing Http Response, statusCode = {}", (Object)statusCode);
        if (statusCode == 200) {
            if (httpResponse.getEntity().getContent() == null) {
                callback.error((Throwable)new ModuleException("Error: No response received from Einstein", (ErrorTypeDefinition)einsteinErrorType));
            }
            return httpResponse.getEntity().getContent();
        }
        if (statusCode == 401) {
            callback.error((Throwable)new AccessTokenExpiredException());
        } else {
            String errorMessage = HttpRequestHelper.readErrorStream(httpResponse.getEntity().getContent());
            log.info("Error in HTTP request. Response code: {}, message: {}", (Object)statusCode, (Object)errorMessage);
            callback.error((Throwable)new ModuleException(String.format("Error in HTTP request. ErrorCode: %d, ErrorMessage: %s", statusCode, errorMessage), (ErrorTypeDefinition)einsteinErrorType));
        }
        return null;
    }
}

