/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.einsteinai.internal.modelsapi.helpers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connector.einsteinai.api.metadata.EinsteinResponseAttributes;
import com.mulesoft.connector.einsteinai.api.metadata.ResponseParameters;
import com.mulesoft.connector.einsteinai.internal.modelsapi.dto.EinsteinChatFromMessagesResponseDTO;
import com.mulesoft.connector.einsteinai.internal.modelsapi.dto.EinsteinEmbeddingResponseDTO;
import com.mulesoft.connector.einsteinai.internal.modelsapi.dto.EinsteinGenerationResponseDTO;
import com.mulesoft.connector.einsteinai.internal.modelsapi.helpers.ObjectMapperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class ResponseHelper {
    private static final ObjectMapper objectMapper = ObjectMapperProvider.create();

    private ResponseHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Result<InputStream, Void> createEinsteinDefaultResponse(String response) {
        return Result.builder().output((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, EinsteinResponseAttributes> createEinsteinFormattedResponse(InputStream responseStream) throws IOException {
        EinsteinGenerationResponseDTO responseDTO = (EinsteinGenerationResponseDTO)objectMapper.readValue(responseStream, EinsteinGenerationResponseDTO.class);
        String generatedText = responseDTO.getGeneration() != null ? responseDTO.getGeneration().getGeneratedText() : "";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("response", (Object)generatedText);
        return Result.builder().output((Object)IOUtils.toInputStream((String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8)).attributes((Object)ResponseHelper.mapResponseAttributes(responseDTO)).attributesMediaType(MediaType.APPLICATION_JAVA).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, ResponseParameters> createEinsteinChatFromMessagesResponse(InputStream responseStream) throws IOException {
        EinsteinChatFromMessagesResponseDTO responseDTO = (EinsteinChatFromMessagesResponseDTO)objectMapper.readValue(responseStream, EinsteinChatFromMessagesResponseDTO.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("generations", responseDTO.getGenerationDetails().getGenerations());
        return Result.builder().output((Object)IOUtils.toInputStream((String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8)).attributes((Object)responseDTO.getGenerationDetails().getParameters()).attributesMediaType(MediaType.APPLICATION_JAVA).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, ResponseParameters> createEinsteinEmbeddingResponse(InputStream response) throws IOException {
        EinsteinEmbeddingResponseDTO responseDTO = (EinsteinEmbeddingResponseDTO)objectMapper.readValue(response, EinsteinEmbeddingResponseDTO.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("embeddings", responseDTO.getEmbeddings());
        return Result.builder().output((Object)IOUtils.toInputStream((String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8)).attributes((Object)ResponseHelper.mapEmbeddingResponseAttributes(responseDTO)).attributesMediaType(MediaType.APPLICATION_JAVA).mediaType(MediaType.APPLICATION_JSON).build();
    }

    private static EinsteinResponseAttributes mapResponseAttributes(EinsteinGenerationResponseDTO responseDTO) {
        return new EinsteinResponseAttributes(responseDTO.getId(), responseDTO.getGeneration() != null ? responseDTO.getGeneration().getId() : null, responseDTO.getGeneration() != null ? responseDTO.getGeneration().getContentQuality() : null, responseDTO.getGeneration() != null ? responseDTO.getGeneration().getParameters() : null, responseDTO.getParameters());
    }

    private static ResponseParameters mapEmbeddingResponseAttributes(EinsteinEmbeddingResponseDTO responseDTO) {
        return new ResponseParameters(responseDTO.getParameters() != null ? responseDTO.getParameters().getTokenUsage() : null, responseDTO.getParameters() != null ? responseDTO.getParameters().getModel() : null, null, responseDTO.getParameters() != null ? responseDTO.getParameters().getObject() : null);
    }
}

