/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.einsteinai.internal.operation;

import com.mulesoft.connector.einsteinai.api.metadata.EinsteinResponseAttributes;
import com.mulesoft.connector.einsteinai.api.metadata.ResponseParameters;
import com.mulesoft.connector.einsteinai.internal.connection.EinsteinConnection;
import com.mulesoft.connector.einsteinai.internal.error.EinsteinErrorType;
import com.mulesoft.connector.einsteinai.internal.error.provider.ChatErrorTypeProvider;
import com.mulesoft.connector.einsteinai.internal.modelsapi.helpers.PromptTemplateHelper;
import com.mulesoft.connector.einsteinai.internal.modelsapi.models.ParamsModelDetails;
import com.mulesoft.connector.einsteinai.internal.params.ReadTimeoutParams;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EinsteinGenerationOperations {
    private static final Logger log = LoggerFactory.getLogger(EinsteinGenerationOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-define-prompt-template")
    @Throws(value={ChatErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinOperationResponse.json")
    public void definePromptTemplate(@Connection EinsteinConnection connection, @Content(primary=true) String template, @Content String instructions, @Content String dataset, @ParameterGroup(name="Additional properties") ParamsModelDetails paramDetails, @ParameterGroup(name="Read timeout") @Summary(value="If defined, it overwrites values in configuration.") ReadTimeoutParams readTimeout, CompletionCallback<InputStream, EinsteinResponseAttributes> callback) {
        log.info("Executing agent defined prompt template operation.");
        try {
            String finalPromptTemplate = PromptTemplateHelper.definePromptTemplate(template, instructions, dataset);
            connection.getRequestHelper().executeGenerateText(finalPromptTemplate, paramDetails, readTimeout, callback);
        }
        catch (Exception e) {
            callback.error((Throwable)new ModuleException("Error while generating prompt from template " + template + ", instructions " + instructions + ", dataset " + dataset, (ErrorTypeDefinition)EinsteinErrorType.CHAT_FAILURE, (Throwable)e));
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="CHAT-answer-prompt")
    @Throws(value={ChatErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinOperationResponse.json")
    public void generateText(@Connection EinsteinConnection connection, @Content String prompt, @ParameterGroup(name="Additional properties") ParamsModelDetails paramDetails, @ParameterGroup(name="Read timeout") @Summary(value="If defined, it overwrites values in configuration.") ReadTimeoutParams readTimeout, CompletionCallback<InputStream, EinsteinResponseAttributes> callback) {
        log.info("Executing chat answer prompt operation.");
        try {
            connection.getRequestHelper().executeGenerateText(prompt, paramDetails, readTimeout, callback);
        }
        catch (Exception e) {
            callback.error((Throwable)new ModuleException("Error while generating text for prompt " + prompt, (ErrorTypeDefinition)EinsteinErrorType.CHAT_FAILURE, (Throwable)e));
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="CHAT-generate-from-messages")
    @Throws(value={ChatErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinChatFromMessagesResponse.json")
    public void generateChatFromMessages(@Connection EinsteinConnection connection, @Content String messages, @ParameterGroup(name="Additional properties") ParamsModelDetails paramDetails, @ParameterGroup(name="Read timeout") @Summary(value="If defined, it overwrites values in configuration.") ReadTimeoutParams readTimeout, CompletionCallback<InputStream, ResponseParameters> callback) {
        log.info("Executing chat generate from message operation.");
        try {
            connection.getRequestHelper().generateChatFromMessages(messages, paramDetails, readTimeout, callback);
        }
        catch (Exception e) {
            callback.error((Throwable)new ModuleException("Error while generating the chat from messages " + messages, (ErrorTypeDefinition)EinsteinErrorType.CHAT_FAILURE, (Throwable)e));
        }
    }
}

