/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.einsteinai.internal.connection.provider.params;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class EinsteinConnectionParameterGroup {
    private static final String SECURITY_TAB = "Security";
    @Parameter
    @Optional(defaultValue="-1")
    @Placement(tab="Advanced", order=1)
    @Summary(value="The maximum number of outbound connections that will be kept open at the same time")
    private Integer maxConnections;
    @Parameter
    @Optional(defaultValue="30")
    @DisplayName(value="Connection Timeout")
    @Placement(tab="Advanced", order=2)
    @Summary(value="The amount of time to wait when initially establishing the TCP connection between the connector and Salesforce Agent before throwing an exception if the connection fails.")
    @ConfigOverride
    private int connectionTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @DisplayName(value="Connection Timeout Unit")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=3)
    @Summary(value="The time unit for Connection Timeout value.")
    @ConfigOverride
    private TimeUnit connectionTimeoutUnit;
    @Parameter
    @DisplayName(value="Connection Idle Timeout")
    @Optional(defaultValue="30")
    @Placement(tab="Advanced", order=4)
    @Summary(value="The number of units that a connection can remain idle before it is closed")
    @ConfigOverride
    private Integer connectionIdleTimeout;
    @Parameter
    @DisplayName(value="Connection Idle Timeout Unit")
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=5)
    @ConfigOverride
    private TimeUnit connectionIdleTimeoutUnit;
    @Parameter
    @DisplayName(value="TLS Configuration")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Security")
    @Summary(value="Protocol to use for communication")
    private TlsContextFactory tlsContextFactory;

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.connectionTimeoutUnit;
    }

    public Integer getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public TimeUnit getConnectionIdleTimeoutUnit() {
        return this.connectionIdleTimeoutUnit;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public Integer getConnectionTimeoutInMillis() {
        return Math.toIntExact(this.connectionTimeoutUnit.toMillis(this.connectionTimeout));
    }

    public Integer getConnectionIdleTimeoutInMillis() {
        return Math.toIntExact(this.connectionIdleTimeoutUnit.toMillis(this.connectionIdleTimeout.intValue()));
    }
}

