/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operations;

import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.config.InferenceConfiguration;
import com.mulesoft.connectors.internal.exception.InferenceErrorType;
import com.mulesoft.connectors.internal.utils.ConnectionUtils;
import com.mulesoft.connectors.internal.utils.PayloadUtils;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import com.mulesoft.connectors.internal.utils.ResponseUtils;
import java.io.InputStream;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferenceOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferenceOperations.class);
    private static final String[] NO_TEMPERATURE_MODELS = new String[]{"o3-mini", "o1", "o1-mini"};
    private static final String ERROR_MSG_FORMAT = "%s result error";

    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-completions")
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> chatCompletion(@Config InferenceConfiguration configuration, @Content InputStream messages) throws ModuleException {
        try {
            JSONArray messagesArray = PayloadUtils.parseInputStreamToJsonArray(messages);
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(configuration);
            LOGGER.debug("Chatting with {}", (Object)chatCompUrl);
            JSONObject payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
            String response = ConnectionUtils.executeREST(chatCompUrl, configuration, payload.toString());
            LOGGER.debug("Chat completions result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, configuration);
        }
        catch (Exception e) {
            LOGGER.error("Error in chat completions: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Chat completions"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-answer-prompt")
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> chatAnswerPrompt(@Config InferenceConfiguration configuration, @Content String prompt) throws ModuleException {
        try {
            JSONArray messagesArray = new JSONArray();
            JSONObject usersPrompt = new JSONObject();
            usersPrompt.put("role", (Object)"user");
            usersPrompt.put("content", (Object)prompt);
            messagesArray.put((Object)usersPrompt);
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(configuration);
            JSONObject payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
            String response = ConnectionUtils.executeREST(chatCompUrl, configuration, payload.toString());
            LOGGER.debug("Chat answer prompt result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, configuration);
        }
        catch (Exception e) {
            LOGGER.error("Error in chat answer prompt: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Chat answer prompt"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Agent-define-prompt-template")
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> promptTemplate(@Config InferenceConfiguration configuration, @Content String template, @Content String instructions, @Content(primary=true) String data) throws ModuleException {
        try {
            JSONArray messagesArray = PayloadUtils.createMessagesArrayWithSystemPrompt(configuration, template + " - " + instructions, data);
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(configuration);
            JSONObject payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
            String response = ConnectionUtils.executeREST(chatCompUrl, configuration, payload.toString());
            LOGGER.debug("Agent define prompt template result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, configuration);
        }
        catch (Exception e) {
            LOGGER.error("Error in agent define prompt template: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Agent define prompt template"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Tools-native-template")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Define a prompt template with instructions, data and tools")
    public Result<InputStream, LLMResponseAttributes> toolsTemplate(@Config InferenceConfiguration configuration, @Content String template, @Content String instructions, @Content(primary=true) String data, @Content @Summary(value="JSON Array defining the tools set to be used in the template so that the LLM can use them if required") InputStream tools) throws ModuleException {
        try {
            JSONArray toolsArray = PayloadUtils.parseInputStreamToJsonArray(tools);
            JSONArray messagesArray = PayloadUtils.createMessagesArrayWithSystemPrompt(configuration, template + " - " + instructions, data);
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(configuration);
            JSONObject payload = PayloadUtils.buildPayload(configuration, messagesArray, toolsArray);
            String response = ConnectionUtils.executeREST(chatCompUrl, configuration, payload.toString());
            LOGGER.debug("Tools use native template result {}", (Object)response);
            return ResponseUtils.processToolsResponse(response, configuration);
        }
        catch (Exception e) {
            LOGGER.error("Error in tools use native template: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Tools use native template"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }

    private JSONArray createMessagesArrayWithSystemPrompt(InferenceConfiguration configuration, String systemContent, String userContent) {
        JSONArray messagesArray = new JSONArray();
        JSONObject systemMessage = new JSONObject();
        systemMessage.put("role", (Object)(ProviderUtils.isAnthropic(configuration) ? "assistant" : "system"));
        systemMessage.put("content", (Object)systemContent);
        messagesArray.put((Object)systemMessage);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)userContent);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    private boolean isOllama(InferenceConfiguration configuration) {
        return "OLLAMA".equals(configuration.getInferenceType());
    }

    private boolean isAnthropic(InferenceConfiguration configuration) {
        return "ANTHROPIC".equals(configuration.getInferenceType());
    }

    private boolean isNvidia(InferenceConfiguration configuration) {
        return "NVIDIA".equals(configuration.getInferenceType());
    }

    private boolean isCohere(InferenceConfiguration configuration) {
        return "COHERE".equals(configuration.getInferenceType());
    }
}

