/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.config.InferenceConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtils.class);

    public static HttpURLConnection getConnectionObject(URL url, InferenceConfiguration configuration) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        conn.setRequestProperty("Accept", "application/json");
        switch (configuration.getInferenceType()) {
            case "ANTHROPIC": {
                conn.setRequestProperty("x-api-key", configuration.getApiKey());
                conn.setRequestProperty("anthropic-version", "2023-06-01");
                break;
            }
            case "PORTKEY": {
                conn.setRequestProperty("x-portkey-api-key", configuration.getApiKey());
                conn.setRequestProperty("x-portkey-virtual-key", configuration.getVirtualKey());
                break;
            }
            case "AZURE_OPENAI": {
                conn.setRequestProperty("api-key", configuration.getApiKey());
                break;
            }
            default: {
                conn.setRequestProperty("Authorization", "Bearer " + configuration.getApiKey());
            }
        }
        return conn;
    }

    public static URL getConnectionURLChatCompletion(InferenceConfiguration configuration) throws MalformedURLException {
        switch (configuration.getInferenceType()) {
            case "PORTKEY": {
                return new URL("https://api.portkey.ai/v1/chat/completions");
            }
            case "GROQ": {
                return new URL("https://api.groq.com/openai/v1/chat/completions");
            }
            case "HUGGING_FACE": {
                return new URL("https://api-inference.huggingface.co/models/" + configuration.getModelName() + "/v1" + "/chat/completions");
            }
            case "OPENROUTER": {
                return new URL("https://openrouter.ai/api/v1/chat/completions");
            }
            case "GITHUB": {
                return new URL("https://models.inference.ai.azure.com/chat/completions");
            }
            case "OLLAMA": {
                return new URL(configuration.getOllamaUrl() + "/chat");
            }
            case "XINFERENCE": {
                return new URL(configuration.getxinferenceUrl() + "/chat/completions");
            }
            case "CEREBRAS": {
                return new URL("https://api.cerebras.ai/v1/chat/completions");
            }
            case "NVIDIA": {
                return new URL("https://integrate.api.nvidia.com/v1/chat/completions");
            }
            case "FIREWORKS": {
                return new URL("https://api.fireworks.ai/inference/v1/chat/completions");
            }
            case "TOGETHER": {
                return new URL("https://api.together.xyz/v1/chat/completions");
            }
            case "DEEPINFRA": {
                return new URL("https://api.deepinfra.com/v1/openai/chat/completions");
            }
            case "PERPLEXITY": {
                return new URL("https://api.perplexity.ai/chat/completions");
            }
            case "XAI": {
                return new URL("https://api.x.ai/v1/chat/completions");
            }
            case "OPENAI": {
                return new URL("https://api.openai.com/v1/chat/completions");
            }
            case "MISTRAL": {
                return new URL("https://api.mistral.ai/v1/chat/completions");
            }
            case "ANTHROPIC": {
                return new URL("https://api.anthropic.com/v1/messages");
            }
            case "AI21LABS": {
                return new URL("https://api.ai21.com/studio/v1/chat/completions");
            }
            case "COHERE": {
                return new URL("https://api.cohere.com/v2/chat");
            }
            case "AZURE_OPENAI": {
                String urlStr = "https://{resource-name}.openai.azure.com/openai/deployments/{deployment-id}/chat/completions?api-version=2024-10-21";
                urlStr = urlStr.replace("{resource-name}", configuration.getAzureOpenaiResourceName()).replace("{deployment-id}", configuration.getAzureOpenaiDeploymentId());
                return new URL(urlStr);
            }
        }
        throw new MalformedURLException("Unsupported inference type: " + configuration.getInferenceType());
    }

    public static String executeREST(URL resourceUrl, InferenceConfiguration configuration, String payload) throws IOException {
        HttpURLConnection conn = ConnectionUtils.getConnectionObject(resourceUrl, configuration);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(120000);
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = payload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
            os.flush();
        }
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return ConnectionUtils.readResponseStream(conn.getInputStream());
        }
        String errorResponse = ConnectionUtils.readResponseStream(conn.getErrorStream());
        LOGGER.error("API request failed with status code: {} and message: {}", (Object)responseCode, (Object)errorResponse);
        throw new IOException("API request failed with status code: " + responseCode + " and message: " + errorResponse);
    }

    public static String readResponseStream(InputStream stream) throws IOException {
        if (stream == null) {
            return "";
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String responseLine;
            StringBuilder response = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine);
            }
            String string = response.toString();
            return string;
        }
    }
}

