/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.config.InferenceConfiguration;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public class PayloadUtils {
    private static final String[] NO_TEMPERATURE_MODELS = new String[]{"o3-mini", "o1", "o1-mini"};

    public static JSONObject buildPayload(InferenceConfiguration configuration, JSONArray messagesArray, JSONArray toolsArray) {
        JSONObject payload = new JSONObject();
        if (!"AZURE_OPENAI".equals(configuration.getInferenceType())) {
            payload.put("model", (Object)configuration.getModelName());
        }
        payload.put("messages", (Object)messagesArray);
        if ("GROQ".equalsIgnoreCase(configuration.getInferenceType()) || "OPENAI".equalsIgnoreCase(configuration.getInferenceType())) {
            payload.put("max_completion_tokens", (Object)configuration.getMaxTokens());
        } else {
            payload.put("max_tokens", (Object)configuration.getMaxTokens());
        }
        String modelName = configuration.getModelName();
        if (!Arrays.asList(NO_TEMPERATURE_MODELS).contains(modelName)) {
            payload.put("temperature", (Object)configuration.getTemperature());
            payload.put("top_p", (Object)configuration.getTopP());
        }
        if (toolsArray != null && !toolsArray.isEmpty()) {
            payload.put("tools", (Object)toolsArray);
        }
        if ("OLLAMA".equals(configuration.getInferenceType()) || "AZURE_OPENAI".equals(configuration.getInferenceType())) {
            payload.put("stream", false);
        }
        return payload;
    }

    public static JSONArray parseInputStreamToJsonArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new JSONArray();
        }
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            String jsonString;
            BufferedReader bufferedReader;
            block14: {
                JSONArray jSONArray;
                bufferedReader = new BufferedReader(reader);
                try {
                    String line;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                    jsonString = stringBuilder.toString().trim();
                    if (!jsonString.isEmpty()) break block14;
                    jSONArray = new JSONArray();
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                bufferedReader.close();
                return jSONArray;
            }
            JSONArray jSONArray = new JSONArray(jsonString);
            bufferedReader.close();
            return jSONArray;
        }
    }

    public static JSONArray createMessagesArrayWithSystemPrompt(InferenceConfiguration configuration, String systemContent, String userContent) {
        JSONArray messagesArray = new JSONArray();
        JSONObject systemMessage = new JSONObject();
        systemMessage.put("role", (Object)(ProviderUtils.isAnthropic(configuration) ? "assistant" : "system"));
        systemMessage.put("content", (Object)systemContent);
        messagesArray.put((Object)systemMessage);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)userContent);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }
}

