/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.api.delegate;

import com.mulesoft.connectors.internal.api.delegate.Moderation;
import com.mulesoft.connectors.internal.config.ModerationConfiguration;
import java.net.HttpURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

public class MistralAIModeration
extends Moderation {
    protected MistralAIModeration(ModerationConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getAPIUrl() {
        return "https://api.mistral.ai/v1/moderations";
    }

    @Override
    protected JSONObject handleModelSpecificRequestPayload(JSONObject payload, Object text, Object images) {
        payload.put("model", (Object)this.configuration.getModerationModelName());
        return payload;
    }

    @Override
    protected String getTextInputAttributeName() {
        return "input";
    }

    @Override
    public void addAuthHeaders(HttpURLConnection conn) {
        conn.addRequestProperty("Authorization", "Bearer " + this.configuration.getApiKey());
    }

    @Override
    protected boolean isFlagged(JSONObject response) {
        boolean isFlagged = false;
        JSONArray results = response.getJSONArray("results");
        block0: for (Object result : results) {
            JSONObject resultObject = (JSONObject)result;
            JSONObject categories = resultObject.getJSONObject("categories");
            for (String key : categories.keySet()) {
                if (!categories.getBoolean(key)) continue;
                isFlagged = true;
                continue block0;
            }
        }
        return isFlagged;
    }
}

