/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.api.delegate;

import com.mulesoft.connectors.internal.api.delegate.Moderation;
import com.mulesoft.connectors.internal.config.ModerationConfiguration;
import java.net.HttpURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

public class OpenAIModeration
extends Moderation {
    protected OpenAIModeration(ModerationConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getAPIUrl() {
        return "https://api.openai.com/v1/moderations";
    }

    @Override
    protected JSONObject handleModelSpecificRequestPayload(JSONObject payload, Object text, Object images) {
        payload.put("model", (Object)this.configuration.getModerationModelName());
        return payload;
    }

    @Override
    protected String getTextInputAttributeName() {
        return "input";
    }

    @Override
    public void addAuthHeaders(HttpURLConnection conn) {
        conn.setRequestProperty("Authorization", "Bearer " + this.configuration.getApiKey());
    }

    @Override
    protected boolean isFlagged(JSONObject llmResponseObject) {
        JSONArray results = llmResponseObject.getJSONArray("results");
        Boolean isFlagged = false;
        for (Object result : results) {
            JSONObject resultObject = (JSONObject)result;
            isFlagged = resultObject.getBoolean("flagged") || isFlagged != false;
        }
        return isFlagged;
    }
}

