/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.config;

import com.mulesoft.connectors.internal.models.ModelNameProvider;
import com.mulesoft.connectors.internal.models.ModelTypeProvider;
import com.mulesoft.connectors.internal.operations.InferenceOperations;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;

@Operations(value={InferenceOperations.class})
@Configuration(name="llm-config")
public class InferenceConfiguration {
    @Parameter
    @Placement(order=1, tab="General")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Inference Type")
    @OfValues(value=ModelTypeProvider.class)
    private String inferenceType;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="API Key")
    private String apiKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=ModelNameProvider.class)
    @Optional(defaultValue="gpt-3.5-turbo")
    private String modelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="500")
    private Number maxTokens;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="0.9")
    private Number temperature;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="0.9")
    private Number topP;
    @Parameter
    @Placement(order=1, tab="Portkey Parameters")
    @Optional(defaultValue="Valid-for-portkey-only")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Virtual Key")
    private String virtualKey;
    @Parameter
    @Placement(order=1, tab="Ollama Parameters")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:11434/api")
    @DisplayName(value="Ollama Base URL")
    private String ollamaUrl;
    @Parameter
    @Placement(order=1, tab="GPT4ALL Parameters")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:4891/v1")
    @DisplayName(value="GPT4ALL Base URL")
    private String gpt4All;
    @Parameter
    @Placement(order=1, tab="LM Studio Parameters")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:1234/v1")
    @DisplayName(value="LM Studio Base URL")
    private String lmStudio;
    @Parameter
    @Placement(order=1, tab="Xinference Parameters")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://127.0.0.1:9997/v1 or https://inference.top/api/v1")
    @DisplayName(value="Xinference Base URL")
    private String xnferenceUrl;
    @Parameter
    @Placement(order=1, tab="Azure OpenAI Parameters")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="Deployment ID")
    private String azureOpenaiDeploymentId;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(order=2, tab="Azure OpenAI Parameters")
    @Optional
    @DisplayName(value="Resource Name")
    private String azureOpenaiResourceName;
    @Parameter
    @Placement(order=1, tab="Azure AI Foundry Parameters")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="API Version")
    private String azureAIFoundryApiVersion;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(order=2, tab="Azure AI Foundry Parameters")
    @Optional
    @DisplayName(value="Resource Name")
    private String azureAIFoundryResourceName;

    public String getApiKey() {
        return this.apiKey;
    }

    public String getInferenceType() {
        return this.inferenceType;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Number getMaxTokens() {
        return this.maxTokens;
    }

    public Number getTemperature() {
        return this.temperature;
    }

    public Number getTopP() {
        return this.topP;
    }

    public String getVirtualKey() {
        return this.virtualKey;
    }

    public String getOllamaUrl() {
        return this.ollamaUrl;
    }

    public String getGpt4All() {
        return this.gpt4All;
    }

    public String getLmStudio() {
        return this.lmStudio;
    }

    public String getxinferenceUrl() {
        return this.xnferenceUrl;
    }

    public String getAzureOpenaiDeploymentId() {
        return this.azureOpenaiDeploymentId;
    }

    public String getAzureOpenaiResourceName() {
        return this.azureOpenaiResourceName;
    }

    public String getAzureAIFoundryApiVersion() {
        return this.azureAIFoundryApiVersion;
    }

    public String getAzureAIFoundryResourceName() {
        return this.azureAIFoundryResourceName;
    }
}

