/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.helpers;

import com.mulesoft.connectors.internal.api.metadata.TokenUsage;
import org.json.JSONObject;

public class TokenHelper {
    public static TokenUsage parseUsageFromResponse(String jsonResponse) throws Exception {
        int totalTokens;
        int completionTokens;
        int promptTokens;
        JSONObject root = new JSONObject(jsonResponse);
        if (root.has("usage")) {
            JSONObject usageNode = root.getJSONObject("usage");
            if (usageNode.has("billed_units") && usageNode.has("tokens")) {
                JSONObject billedUnitsNode = usageNode.getJSONObject("billed_units");
                promptTokens = billedUnitsNode.getInt("input_tokens");
                completionTokens = billedUnitsNode.getInt("output_tokens");
                totalTokens = promptTokens + completionTokens;
            } else if (usageNode.has("input_tokens") && usageNode.has("output_tokens")) {
                promptTokens = usageNode.getInt("input_tokens");
                completionTokens = usageNode.getInt("output_tokens");
                totalTokens = promptTokens + completionTokens;
            } else {
                promptTokens = usageNode.getInt("prompt_tokens");
                completionTokens = usageNode.getInt("completion_tokens");
                totalTokens = usageNode.getInt("total_tokens");
            }
        } else if (root.has("usageMetadata")) {
            JSONObject usageMetadataNode = root.getJSONObject("usageMetadata");
            promptTokens = usageMetadataNode.getInt("promptTokenCount");
            completionTokens = usageMetadataNode.getInt("candidatesTokenCount");
            totalTokens = usageMetadataNode.getInt("totalTokenCount");
        } else {
            promptTokens = root.getInt("prompt_eval_count");
            completionTokens = root.getInt("eval_count");
            totalTokens = promptTokens + completionTokens;
        }
        TokenUsage usage = new TokenUsage(promptTokens, completionTokens, totalTokens);
        return usage;
    }
}

