/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operations;

import com.mulesoft.connectors.internal.api.delegate.Moderation;
import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.config.ModerationConfiguration;
import com.mulesoft.connectors.internal.exception.InferenceErrorType;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModerationOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModerationOperations.class);
    private static final String ERROR_MSG_FORMAT = "%s moderation error";

    @MediaType(value="application/json", strict=false)
    @Alias(value="Toxicity-Detection-Text")
    @DisplayName(value="[Toxicity] Detection by Text")
    @OutputJsonType(schema="api/response/ResponseModeration.json")
    @Summary(value="Detects toxic input by text and classifies it into categories.")
    public Result<InputStream, LLMResponseAttributes> textModeration(@Config ModerationConfiguration configuration, @Content(primary=true) @Summary(value="Text to moderate. Can be a single string or an array of strings") InputStream text) throws ModuleException {
        try {
            return Moderation.getInstance(configuration).moderate(text);
        }
        catch (Exception e) {
            LOGGER.error("Error in moderation: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Moderation"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }
}

