/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operations;

import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.config.InferenceConfiguration;
import com.mulesoft.connectors.internal.config.VisionConfiguration;
import com.mulesoft.connectors.internal.exception.InferenceErrorType;
import com.mulesoft.connectors.internal.utils.ConnectionUtils;
import com.mulesoft.connectors.internal.utils.PayloadUtils;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import com.mulesoft.connectors.internal.utils.ResponseUtils;
import java.io.InputStream;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisionOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisionOperations.class);
    private static final String ERROR_MSG_FORMAT = "%s result error";

    @MediaType(value="application/json", strict=false)
    @Alias(value="Read-image")
    @DisplayName(value="[Image] Read by URL")
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> readImage(@Config VisionConfiguration configuration, @Content String prompt, @Content(primary=true) String imageUrl) throws ModuleException {
        try {
            JSONArray messagesArray = PayloadUtils.createRequestImageURL(configuration.getInferenceType(), prompt, imageUrl);
            InferenceConfiguration inferenceConfig = ProviderUtils.convertToInferenceConfig(configuration);
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(inferenceConfig);
            LOGGER.debug("Chatting with {}", (Object)chatCompUrl);
            JSONObject payload = PayloadUtils.buildPayload(inferenceConfig, messagesArray, null);
            String response = ConnectionUtils.executeREST(chatCompUrl, inferenceConfig, payload.toString());
            LOGGER.debug("Read Image result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, inferenceConfig);
        }
        catch (Exception e) {
            LOGGER.error("Error in Read Image: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Read Image"), (ErrorTypeDefinition)InferenceErrorType.VISION, (Throwable)e);
        }
    }
}

