/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.config.InferenceConfiguration;
import com.mulesoft.connectors.internal.operations.InferenceOperations;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferenceOperations.class);

    public static HttpURLConnection getConnectionObject(URL url, InferenceConfiguration configuration) throws IOException {
        HttpURLConnection conn;
        if ("VERTEX_AI_EXPRESS".equalsIgnoreCase(configuration.getInferenceType())) {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("key", configuration.getApiKey());
            String fullUrl = url.toString() + "?" + ConnectionUtils.getQueryParams(queryParams);
            conn = (HttpURLConnection)new URL(fullUrl).openConnection();
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        LOGGER.debug("path : ", (Object)conn.getURL().getPath());
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        conn.setRequestProperty("Accept", "application/json");
        switch (configuration.getInferenceType()) {
            case "ANTHROPIC": {
                conn.setRequestProperty("x-api-key", configuration.getApiKey());
                conn.setRequestProperty("anthropic-version", "2023-06-01");
                break;
            }
            case "PORTKEY": {
                conn.setRequestProperty("x-portkey-api-key", configuration.getApiKey());
                conn.setRequestProperty("x-portkey-virtual-key", configuration.getVirtualKey());
                break;
            }
            case "AZURE_OPENAI": {
                conn.setRequestProperty("api-key", configuration.getApiKey());
                break;
            }
            case "VERTEX_AI_EXPRESS": {
                break;
            }
            case "AZURE_AI_FOUNDRY": {
                conn.setRequestProperty("api-key", configuration.getApiKey());
                break;
            }
            default: {
                conn.setRequestProperty("Authorization", "Bearer " + configuration.getApiKey());
            }
        }
        return conn;
    }

    public static URL getConnectionURLChatCompletion(InferenceConfiguration configuration) throws MalformedURLException {
        switch (configuration.getInferenceType()) {
            case "PORTKEY": {
                return new URL("https://api.portkey.ai/v1/chat/completions");
            }
            case "GROQ": {
                return new URL("https://api.groq.com/openai/v1/chat/completions");
            }
            case "HUGGING_FACE": {
                return new URL("https://router.huggingface.co/hf-inference/models/" + configuration.getModelName() + "/v1" + "/chat/completions");
            }
            case "OPENROUTER": {
                return new URL("https://openrouter.ai/api/v1/chat/completions");
            }
            case "GITHUB": {
                return new URL("https://models.inference.ai.azure.com/chat/completions");
            }
            case "OLLAMA": {
                return new URL(configuration.getOllamaUrl() + "/chat");
            }
            case "XINFERENCE": {
                return new URL(configuration.getxinferenceUrl() + "/chat/completions");
            }
            case "CEREBRAS": {
                return new URL("https://api.cerebras.ai/v1/chat/completions");
            }
            case "NVIDIA": {
                return new URL("https://integrate.api.nvidia.com/v1/chat/completions");
            }
            case "FIREWORKS": {
                return new URL("https://api.fireworks.ai/inference/v1/chat/completions");
            }
            case "TOGETHER": {
                return new URL("https://api.together.xyz/v1/chat/completions");
            }
            case "DEEPINFRA": {
                return new URL("https://api.deepinfra.com/v1/openai/chat/completions");
            }
            case "PERPLEXITY": {
                return new URL("https://api.perplexity.ai/chat/completions");
            }
            case "XAI": {
                return new URL("https://api.x.ai/v1/chat/completions");
            }
            case "OPENAI": {
                return new URL("https://api.openai.com/v1/chat/completions");
            }
            case "MISTRAL": {
                return new URL("https://api.mistral.ai/v1/chat/completions");
            }
            case "ANTHROPIC": {
                return new URL("https://api.anthropic.com/v1/messages");
            }
            case "AI21LABS": {
                return new URL("https://api.ai21.com/studio/v1/chat/completions");
            }
            case "COHERE": {
                return new URL("https://api.cohere.com/v2/chat");
            }
            case "AZURE_OPENAI": {
                String urlStr = "https://{resource-name}.openai.azure.com/openai/deployments/{deployment-id}/chat/completions?api-version=2024-10-21";
                urlStr = urlStr.replace("{resource-name}", configuration.getAzureOpenaiResourceName()).replace("{deployment-id}", configuration.getAzureOpenaiDeploymentId());
                return new URL(urlStr);
            }
            case "VERTEX_AI_EXPRESS": {
                String vertexAIUrlStr = "https://aiplatform.googleapis.com/v1/publishers/google/models/{MODEL_ID}:generateContent";
                vertexAIUrlStr = vertexAIUrlStr.replace("{MODEL_ID}", configuration.getModelName());
                return new URL(vertexAIUrlStr);
            }
            case "AZURE_AI_FOUNDRY": {
                String aifurlStr = "https://{resource-name}.services.ai.azure.com/models/chat/completions?api-version={api-version}";
                aifurlStr = aifurlStr.replace("{resource-name}", configuration.getAzureAIFoundryResourceName()).replace("{api-version}", configuration.getAzureAIFoundryApiVersion());
                return new URL(aifurlStr);
            }
            case "GPT4ALL": {
                return new URL(configuration.getGpt4All() + "/chat/completions");
            }
            case "LMSTUDIO": {
                return new URL(configuration.getLmStudio() + "/chat/completions");
            }
        }
        throw new MalformedURLException("Unsupported inference type: " + configuration.getInferenceType());
    }

    public static String executeREST(URL resourceUrl, InferenceConfiguration configuration, String payload) throws IOException {
        HttpURLConnection conn = ConnectionUtils.getConnectionObject(resourceUrl, configuration);
        return ConnectionUtils.executeREST(conn, payload);
    }

    public static String executeREST(HttpURLConnection conn, String payload) throws IOException {
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(120000);
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = payload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
            os.flush();
        }
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return ConnectionUtils.readResponseStream(conn.getInputStream());
        }
        String errorResponse = ConnectionUtils.readResponseStream(conn.getErrorStream());
        LOGGER.error("API request failed with status code: {} and message: {}", (Object)responseCode, (Object)errorResponse);
        throw new IOException("API request failed with status code: " + responseCode + " and message: " + errorResponse);
    }

    public static String readResponseStream(InputStream stream) throws IOException {
        if (stream == null) {
            return "";
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String responseLine;
            StringBuilder response = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine);
            }
            String string = response.toString();
            return string;
        }
    }

    public static String getQueryParams(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (query.length() > 0) {
                query.append("&");
            }
            query.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return query.toString();
    }
}

