/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.config.InferenceConfiguration;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public class PayloadUtils {
    private static final String[] NO_TEMPERATURE_MODELS = new String[]{"o3-mini", "o1", "o1-mini"};

    public static JSONObject buildPayload(InferenceConfiguration configuration, JSONArray messagesArray, JSONArray toolsArray) {
        JSONObject payload = new JSONObject();
        if (!"AZURE_OPENAI".equals(configuration.getInferenceType())) {
            payload.put("model", (Object)configuration.getModelName());
        }
        payload.put("messages", (Object)messagesArray);
        if ("GROQ".equalsIgnoreCase(configuration.getInferenceType()) || "OPENAI".equalsIgnoreCase(configuration.getInferenceType())) {
            payload.put("max_completion_tokens", (Object)configuration.getMaxTokens());
        } else {
            payload.put("max_tokens", (Object)configuration.getMaxTokens());
        }
        String modelName = configuration.getModelName();
        if (!Arrays.asList(NO_TEMPERATURE_MODELS).contains(modelName)) {
            payload.put("temperature", (Object)configuration.getTemperature());
            payload.put("top_p", (Object)configuration.getTopP());
        }
        if (toolsArray != null && !toolsArray.isEmpty()) {
            payload.put("tools", (Object)toolsArray);
        }
        if ("OLLAMA".equals(configuration.getInferenceType()) || "AZURE_OPENAI".equals(configuration.getInferenceType())) {
            payload.put("stream", false);
        }
        return payload;
    }

    public static JSONObject buildVertexAIPayload(InferenceConfiguration configuration, String prompt, JSONArray safetySettings, JSONObject systemInstruction, JSONArray tools) {
        JSONObject payload = new JSONObject();
        JSONArray partsArray = new JSONArray();
        JSONObject usersPrompt = new JSONObject();
        usersPrompt.put("text", (Object)prompt);
        partsArray.put((Object)usersPrompt);
        JSONObject userContent = new JSONObject();
        userContent.put("role", (Object)"user");
        userContent.put("parts", (Object)partsArray);
        JSONArray contentsArray = new JSONArray();
        contentsArray.put((Object)userContent);
        payload.put("contents", (Object)contentsArray);
        if (systemInstruction != null) {
            payload.put("systemInstruction", (Object)systemInstruction);
        }
        JSONObject generationConfig = new JSONObject();
        generationConfig.put("responseModalities", (Object)new String[]{"TEXT"});
        generationConfig.put("temperature", (Object)configuration.getTemperature());
        generationConfig.put("maxOutputTokens", (Object)configuration.getMaxTokens());
        generationConfig.put("topP", (Object)configuration.getTopP());
        payload.put("generationConfig", (Object)generationConfig);
        if (safetySettings != null && !safetySettings.isEmpty()) {
            payload.put("safetySettings", (Object)safetySettings);
        }
        if (tools != null && !tools.isEmpty()) {
            payload.put("tools", (Object)tools);
        }
        return payload;
    }

    public static JSONArray parseInputStreamToJsonArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new JSONArray();
        }
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            String jsonString;
            BufferedReader bufferedReader;
            block14: {
                JSONArray jSONArray;
                bufferedReader = new BufferedReader(reader);
                try {
                    String line;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                    jsonString = stringBuilder.toString().trim();
                    if (!jsonString.isEmpty()) break block14;
                    jSONArray = new JSONArray();
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                bufferedReader.close();
                return jSONArray;
            }
            JSONArray jSONArray = new JSONArray(jsonString);
            bufferedReader.close();
            return jSONArray;
        }
    }

    public static JSONArray createMessagesArrayWithSystemPrompt(InferenceConfiguration configuration, String systemContent, String userContent) {
        JSONArray messagesArray = new JSONArray();
        JSONObject systemMessage = new JSONObject();
        systemMessage.put("role", (Object)(ProviderUtils.isAnthropic(configuration) ? "assistant" : "system"));
        systemMessage.put("content", (Object)systemContent);
        messagesArray.put((Object)systemMessage);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)userContent);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    public static JSONArray createRequestImageURL(String provider, String prompt, String imageUrl) {
        if (provider.equalsIgnoreCase("ANTHROPIC")) {
            return PayloadUtils.createAnthropicImageURLRequest(prompt, imageUrl);
        }
        return PayloadUtils.createImageURLRequest(prompt, imageUrl);
    }

    private static JSONArray createImageURLRequest(String prompt, String imageUrl) {
        JSONArray messagesArray = new JSONArray();
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        JSONArray contentArray = new JSONArray();
        JSONObject textContent = new JSONObject();
        textContent.put("type", (Object)"text");
        textContent.put("text", (Object)prompt);
        contentArray.put((Object)textContent);
        JSONObject imageContent = new JSONObject();
        imageContent.put("type", (Object)"image_url");
        JSONObject imageMessage = new JSONObject();
        imageMessage.put("url", (Object)imageUrl);
        imageContent.put("image_url", (Object)imageMessage);
        contentArray.put((Object)imageContent);
        userMessage.put("content", (Object)contentArray);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    private static JSONArray createAnthropicImageURLRequest(String prompt, String imageUrl) {
        JSONArray messagesArray = new JSONArray();
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        JSONArray contentArray = new JSONArray();
        JSONObject imageContent = new JSONObject();
        imageContent.put("type", (Object)"image");
        JSONObject imageSource = new JSONObject();
        imageSource.put("type", (Object)"url");
        imageSource.put("url", (Object)imageUrl);
        imageContent.put("source", (Object)imageSource);
        contentArray.put((Object)imageContent);
        JSONObject textContent = new JSONObject();
        textContent.put("type", (Object)"text");
        textContent.put("text", (Object)prompt);
        contentArray.put((Object)textContent);
        userMessage.put("content", (Object)contentArray);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    public static JSONObject buildChatAnswerPromptPayload(InferenceConfiguration configuration, String prompt) {
        JSONObject payload;
        if ("VERTEX_AI_EXPRESS".equalsIgnoreCase(configuration.getInferenceType())) {
            JSONArray safetySettings = new JSONArray();
            JSONObject systemInstruction = new JSONObject();
            JSONArray tools = new JSONArray();
            payload = PayloadUtils.buildVertexAIPayload(configuration, prompt, safetySettings, systemInstruction, tools);
        } else {
            JSONArray messagesArray = new JSONArray();
            JSONObject usersPrompt = new JSONObject();
            usersPrompt.put("role", (Object)"user");
            usersPrompt.put("content", (Object)prompt);
            messagesArray.put((Object)usersPrompt);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
        }
        return payload;
    }

    public static JSONObject buildPromptTemplatePayload(InferenceConfiguration configuration, String template, String instructions, String data) {
        JSONObject payload;
        if ("VERTEX_AI_EXPRESS".equalsIgnoreCase(configuration.getInferenceType())) {
            JSONObject part = new JSONObject();
            part.put("text", (Object)(template + " - " + instructions));
            JSONArray parts = new JSONArray();
            parts.put((Object)part);
            JSONObject systemInstruction = new JSONObject();
            systemInstruction.put("parts", (Object)parts);
            JSONArray safetySettings = new JSONArray();
            JSONArray tools = new JSONArray();
            payload = PayloadUtils.buildVertexAIPayload(configuration, data, safetySettings, systemInstruction, tools);
        } else {
            JSONArray messagesArray = PayloadUtils.createMessagesArrayWithSystemPrompt(configuration, template + " - " + instructions, data);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
        }
        return payload;
    }

    public static JSONObject buildToolsTemplatePayload(InferenceConfiguration configuration, String template, String instructions, String data, InputStream tools) throws IOException {
        JSONObject payload;
        if ("VERTEX_AI_EXPRESS".equalsIgnoreCase(configuration.getInferenceType())) {
            JSONObject part = new JSONObject();
            part.put("text", (Object)(template + " - " + instructions));
            JSONArray parts = new JSONArray();
            parts.put((Object)part);
            JSONObject systemInstruction = new JSONObject();
            systemInstruction.put("parts", (Object)parts);
            JSONArray toolsArray = PayloadUtils.parseInputStreamToJsonArray(tools);
            JSONArray safetySettings = new JSONArray();
            payload = PayloadUtils.buildVertexAIPayload(configuration, data, safetySettings, systemInstruction, toolsArray);
        } else {
            JSONArray toolsArray = PayloadUtils.parseInputStreamToJsonArray(tools);
            JSONArray messagesArray = PayloadUtils.createMessagesArrayWithSystemPrompt(configuration, template + " - " + instructions, data);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, toolsArray);
        }
        return payload;
    }
}

