/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.config.InferenceConfiguration;
import com.mulesoft.connectors.internal.config.VisionConfiguration;
import java.lang.reflect.Field;

public class ProviderUtils {
    public static boolean isOllama(InferenceConfiguration configuration) {
        return "OLLAMA".equals(configuration.getInferenceType());
    }

    public static boolean isAnthropic(InferenceConfiguration configuration) {
        return "ANTHROPIC".equals(configuration.getInferenceType());
    }

    public static boolean isNvidia(InferenceConfiguration configuration) {
        return "NVIDIA".equals(configuration.getInferenceType());
    }

    public static boolean isCohere(InferenceConfiguration configuration) {
        return "COHERE".equals(configuration.getInferenceType());
    }

    public static boolean isVertexAIExpress(InferenceConfiguration configuration) {
        return "VERTEX_AI_EXPRESS".equals(configuration.getInferenceType());
    }

    public static InferenceConfiguration convertToInferenceConfig(VisionConfiguration visionConfig) {
        InferenceConfiguration inferenceConfig = new InferenceConfiguration();
        try {
            Field inferenceTypeField = InferenceConfiguration.class.getDeclaredField("inferenceType");
            inferenceTypeField.setAccessible(true);
            inferenceTypeField.set(inferenceConfig, visionConfig.getInferenceType());
            Field apiKeyField = InferenceConfiguration.class.getDeclaredField("apiKey");
            apiKeyField.setAccessible(true);
            apiKeyField.set(inferenceConfig, visionConfig.getApiKey());
            Field modelNameField = InferenceConfiguration.class.getDeclaredField("modelName");
            modelNameField.setAccessible(true);
            modelNameField.set(inferenceConfig, visionConfig.getModelName());
            Field maxTokensField = InferenceConfiguration.class.getDeclaredField("maxTokens");
            maxTokensField.setAccessible(true);
            maxTokensField.set(inferenceConfig, visionConfig.getMaxTokens());
            Field temperatureField = InferenceConfiguration.class.getDeclaredField("temperature");
            temperatureField.setAccessible(true);
            temperatureField.set(inferenceConfig, visionConfig.getTemperature());
            Field topPField = InferenceConfiguration.class.getDeclaredField("topP");
            topPField.setAccessible(true);
            topPField.set(inferenceConfig, visionConfig.getTemperature());
            Field ollamaURLField = InferenceConfiguration.class.getDeclaredField("ollamaUrl");
            ollamaURLField.setAccessible(true);
            ollamaURLField.set(inferenceConfig, visionConfig.getOllamaUrl());
            Field virtualKeyField = InferenceConfiguration.class.getDeclaredField("virtualKey");
            virtualKeyField.setAccessible(true);
            virtualKeyField.set(inferenceConfig, visionConfig.getVirtualKey());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Error converting VisionConfiguration to InferenceConfiguration", e);
        }
        return inferenceConfig;
    }
}

