/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.connection.types;

import com.mulesoft.connectors.internal.api.proxy.HttpProxyConfig;
import com.mulesoft.connectors.internal.connection.types.Vision;
import com.mulesoft.connectors.internal.models.vision.ModelNameProvider;
import com.mulesoft.connectors.internal.models.vision.ModelTypeProvider;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

@Alias(value="vision")
@DisplayName(value="Vision Models")
public class VisionProvider
implements CachedConnectionProvider<Vision>,
Startable,
Stoppable {
    private HttpClient httpClient;
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Inference Type")
    @OfValues(value=ModelTypeProvider.class)
    private String inferenceType;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="API Key")
    private String apiKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=ModelNameProvider.class)
    @Optional(defaultValue="gpt-4o-mini")
    private String modelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="500")
    private Number maxTokens;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="0.9")
    private Number temperature;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="0.9")
    private Number topP;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Timeout (milliseconds)")
    @Optional(defaultValue="60000")
    private int timeout;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:11434/api")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Ollama] Base URL")
    private String ollamaUrl;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="https://server.endpoint.com")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[OpenAI Compatible] Base URL")
    private String openCompatibleURL;
    @Parameter
    @Optional(defaultValue="Portkey-virtual-key")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Portkey] Virtual Key")
    private String virtualKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="us-central1")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[VertexAI] Location Id")
    private String vertexAILocationId;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @Placement(tab="Additional Properties")
    @DisplayName(value="[VertexAI] Project Id")
    private String vertexAIProjectId;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(tab="Additional Properties")
    @Optional
    @DisplayName(value="[VertexAI] Service Account Key")
    private String vertexAIServiceAccountKey;
    @Parameter
    @Placement(order=2, tab="Advanced")
    @Optional
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Placement(tab="Proxy", order=1)
    private HttpProxyConfig proxyConfig;

    public String getInferenceType() {
        return this.inferenceType;
    }

    public void setInferenceType(String inferenceType) {
        this.inferenceType = inferenceType;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Number getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Number maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Number getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Number temperature) {
        this.temperature = temperature;
    }

    public Number getTopP() {
        return this.topP;
    }

    public void setTopP(Number topP) {
        this.topP = topP;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setOllamaUrl(String ollamaUrl) {
        this.ollamaUrl = ollamaUrl;
    }

    public void setOpenAICompatibleURL(String openCompatibleURL) {
        this.openCompatibleURL = openCompatibleURL;
    }

    public void setVirtualKey(String virtualKey) {
        this.virtualKey = virtualKey;
    }

    public void setVertexAILocationId(String vertexAILocationId) {
        this.vertexAILocationId = vertexAILocationId;
    }

    public void setVertexAIProjectId(String vertexAIProjectId) {
        this.vertexAIProjectId = vertexAIProjectId;
    }

    public Vision connect() throws ConnectionException {
        return new Vision(this.httpClient, this.timeout, this.inferenceType, this.apiKey, this.modelName, this.maxTokens, this.temperature, this.topP, this.ollamaUrl, this.openCompatibleURL, this.virtualKey, this.vertexAIProjectId, this.vertexAILocationId, this.vertexAIServiceAccountKey);
    }

    public void disconnect(Vision vision) {
    }

    public ConnectionValidationResult validate(Vision vision) {
        try {
            vision.validate();
            return ConnectionValidationResult.success();
        }
        catch (ConnectionException e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void start() throws MuleException {
        HttpClientConfiguration config = this.createClientConfiguration();
        this.httpClient = this.httpService.getClientFactory().create(config);
        this.httpClient.start();
    }

    private HttpClientConfiguration createClientConfiguration() {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder().setName(this.configName);
        if (null != this.tlsContext) {
            builder.setTlsContextFactory(this.tlsContext);
        } else {
            builder.setTlsContextFactory(TlsContextFactory.builder().buildDefault());
        }
        if (this.proxyConfig != null) {
            builder.setProxyConfig((ProxyConfig)this.proxyConfig);
        }
        return builder.build();
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }
}

