/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operations;

import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.config.ImageGenerationConfig;
import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.connection.ModerationImageGenerationBase;
import com.mulesoft.connectors.internal.exception.InferenceErrorType;
import com.mulesoft.connectors.internal.utils.ConnectionUtils;
import com.mulesoft.connectors.internal.utils.PayloadUtils;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import com.mulesoft.connectors.internal.utils.ResponseUtils;
import java.io.InputStream;
import java.net.URL;
import org.json.JSONObject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageGenerationModelOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageGenerationModelOperations.class);
    private static final String ERROR_MSG_FORMAT = "%s result error";

    @MediaType(value="application/json", strict=false)
    @Alias(value="Generate-image")
    @DisplayName(value="[Image] Generate (only Base64)")
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> generateImage(@Config ImageGenerationConfig configuration, @Connection ModerationImageGenerationBase connection, @Content String prompt) throws ModuleException {
        try {
            JSONObject requestJson = PayloadUtils.createRequestImageGeneration(connection.getInferenceType(), prompt);
            ChatCompletionBase baseConnection = ProviderUtils.convertToBaseConnection(connection);
            URL imageGenerationUrl = ConnectionUtils.getConnectionURLImageGeneration(baseConnection);
            LOGGER.debug("Generate Image with {}", (Object)imageGenerationUrl);
            JSONObject payload = PayloadUtils.buildPayloadImageGeneration(connection, requestJson);
            String response = ConnectionUtils.executeRestImageGeneration(imageGenerationUrl, baseConnection, payload.toString());
            LOGGER.debug("Generate Image result {}", (Object)response);
            return ResponseUtils.processImageGenResponse(response, baseConnection);
        }
        catch (Exception e) {
            LOGGER.error("Error in Generate Image: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Generate Image"), (ErrorTypeDefinition)InferenceErrorType.IMAGE_GENERATION, (Throwable)e);
        }
    }
}

