/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.connection.ModerationImageGenerationBase;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.http.api.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderUtils.class);

    public static boolean isOllama(ChatCompletionBase configuration) {
        return "OLLAMA".equals(configuration.getInferenceType());
    }

    public static boolean isHuggingFace(ChatCompletionBase configuration) {
        return "HUGGING_FACE".equals(configuration.getInferenceType());
    }

    public static boolean isAnthropic(ChatCompletionBase configuration) {
        return "ANTHROPIC".equals(configuration.getInferenceType());
    }

    public static boolean isNvidia(ChatCompletionBase configuration) {
        return "NVIDIA".equals(configuration.getInferenceType());
    }

    public static boolean isCohere(ChatCompletionBase configuration) {
        return "COHERE".equals(configuration.getInferenceType());
    }

    public static boolean isVertexAIExpress(ChatCompletionBase configuration) {
        return "VERTEX_AI_EXPRESS".equals(configuration.getInferenceType());
    }

    public static boolean isVertexAI(ChatCompletionBase configuration) {
        return "VERTEX_AI".equals(configuration.getInferenceType());
    }

    public static String getProviderByModel(String modelName) {
        LOGGER.debug("model name {}", (Object)modelName);
        if (modelName == null || modelName.isEmpty()) {
            return "Unknown";
        }
        String upperName = modelName.toUpperCase();
        if (upperName.startsWith("GEMINI")) {
            return "Google";
        }
        if (upperName.startsWith("CLAUDE")) {
            return "Anthropic";
        }
        if (upperName.startsWith("META")) {
            return "Meta";
        }
        return "Unknown";
    }

    public static boolean isOpenAI(ChatCompletionBase configuration) {
        return "OPENAI".equals(configuration.getInferenceType());
    }

    public static boolean isStabilityAI(ChatCompletionBase configuration) {
        return "STABILITY_AI".equals(configuration.getInferenceType());
    }

    public static boolean isXAI(ChatCompletionBase configuration) {
        return "XAI".equals(configuration.getInferenceType());
    }

    @NotNull
    public static ChatCompletionBase convertToBaseConnection(ModerationImageGenerationBase imageGenerationBase) {
        BaseConnectionImpl baseConnection = new BaseConnectionImpl();
        baseConnection.setHttpClient(imageGenerationBase.getHttpClient());
        baseConnection.setInferenceType(imageGenerationBase.getInferenceType());
        baseConnection.setApiKey(imageGenerationBase.getApiKey());
        baseConnection.setModelName(imageGenerationBase.getModelName());
        baseConnection.setTimeout(imageGenerationBase.getTimeout());
        return baseConnection;
    }

    private static class BaseConnectionImpl
    implements ChatCompletionBase {
        private HttpClient httpClient;
        private String inferenceType;
        private String apiKey;
        private String modelName;
        private int timeout;
        private Number maxTokens;
        private Number temperature;
        private Number topP;
        private String azureAIFoundryApiVersion;
        private String azureAIFoundryResourceName;
        private String azureOpenaiDeploymentId;
        private String azureOpenaiResourceName;
        private String dataBricksModelUrl;
        private String dockerModelUrl;
        private String gpt4All;
        private String ibmWatsonApiVersion;
        private String ibmWatsonProjectID;
        private String lmStudio;
        private String ollamaUrl;
        private String openCompatibleURL;
        private String virtualKey;
        private String xnferenceUrl;
        private String vertexAIProjectId;
        private String vertexAILocationId;
        private String vertexAIServiceAccountKey;

        private BaseConnectionImpl() {
        }

        @Override
        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        public void setHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        @Override
        public String getInferenceType() {
            return this.inferenceType;
        }

        public void setInferenceType(String inferenceType) {
            this.inferenceType = inferenceType;
        }

        @Override
        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public Number getMaxTokens() {
            return this.maxTokens;
        }

        public void setMaxTokens(Number maxTokens) {
            this.maxTokens = maxTokens;
        }

        @Override
        public Number getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Number temperature) {
            this.temperature = temperature;
        }

        @Override
        public Number getTopP() {
            return this.topP;
        }

        public void setTopP(Number topP) {
            this.topP = topP;
        }

        @Override
        public String getAzureAIFoundryApiVersion() {
            return this.azureAIFoundryApiVersion;
        }

        public void setAzureAIFoundryApiVersion(String azureAIFoundryApiVersion) {
            this.azureAIFoundryApiVersion = azureAIFoundryApiVersion;
        }

        @Override
        public String getAzureAIFoundryResourceName() {
            return this.azureAIFoundryResourceName;
        }

        public void setAzureAIFoundryResourceName(String azureAIFoundryResourceName) {
            this.azureAIFoundryResourceName = azureAIFoundryResourceName;
        }

        @Override
        public String getAzureOpenaiDeploymentId() {
            return this.azureOpenaiDeploymentId;
        }

        public void setAzureOpenaiDeploymentId(String azureOpenaiDeploymentId) {
            this.azureOpenaiDeploymentId = azureOpenaiDeploymentId;
        }

        @Override
        public String getAzureOpenaiResourceName() {
            return this.azureOpenaiResourceName;
        }

        public void setAzureOpenaiResourceName(String azureOpenaiResourceName) {
            this.azureOpenaiResourceName = azureOpenaiResourceName;
        }

        @Override
        public String getDataBricksModelUrl() {
            return this.dataBricksModelUrl;
        }

        public void dataBricksModelUrl(String dataBricksModelUrl) {
            this.dataBricksModelUrl = dataBricksModelUrl;
        }

        @Override
        public String getDockerModelUrl() {
            return this.dockerModelUrl;
        }

        public void setDockerModelUrl(String dockerModelUrl) {
            this.dockerModelUrl = dockerModelUrl;
        }

        @Override
        public String getGpt4All() {
            return this.gpt4All;
        }

        public void setGpt4All(String gpt4All) {
            this.gpt4All = gpt4All;
        }

        @Override
        public String getIBMWatsonApiVersion() {
            return this.ibmWatsonApiVersion;
        }

        public void setIBMWatsonApiVersion(String ibmWatsonApiVersion) {
            this.ibmWatsonApiVersion = ibmWatsonApiVersion;
        }

        @Override
        public String getibmWatsonProjectID() {
            return this.ibmWatsonProjectID;
        }

        public void setibmWatsonProjectID(String ibmWatsonProjectID) {
            this.ibmWatsonProjectID = ibmWatsonProjectID;
        }

        @Override
        public String getLmStudio() {
            return this.lmStudio;
        }

        public void setLmStudio(String lmStudio) {
            this.lmStudio = lmStudio;
        }

        @Override
        public String getOllamaUrl() {
            return this.ollamaUrl;
        }

        public void setOllamaUrl(String ollamaUrl) {
            this.ollamaUrl = ollamaUrl;
        }

        @Override
        public String getOpenAICompatibleURL() {
            return this.openCompatibleURL;
        }

        public void setOpenAICompatibleURL(String openCompatibleURL) {
            this.openCompatibleURL = openCompatibleURL;
        }

        @Override
        public String getVirtualKey() {
            return this.virtualKey;
        }

        public void setVirtualKey(String virtualKey) {
            this.virtualKey = virtualKey;
        }

        @Override
        public String getxinferenceUrl() {
            return this.xnferenceUrl;
        }

        public void setXinferenceUrl(String xnferenceUrl) {
            this.xnferenceUrl = xnferenceUrl;
        }

        @Override
        public String getVertexAIProjectId() {
            return this.vertexAIProjectId;
        }

        public void setVertexAIProjectId(String vertexAIProjectId) {
            this.vertexAIProjectId = vertexAIProjectId;
        }

        @Override
        public String getVertexAILocationId() {
            return this.vertexAILocationId;
        }

        public void setVertexAILocationId(String vertexAILocationId) {
            this.vertexAILocationId = vertexAILocationId;
        }

        @Override
        public String getVertexAIServiceAccountKey() {
            return this.vertexAIServiceAccountKey;
        }

        public void setVertexAIServiceAccountKey(String vertexAIServiceAccountKey) {
            this.vertexAIServiceAccountKey = vertexAIServiceAccountKey;
        }
    }
}

