/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.api.metadata.TokenUsage;
import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.helpers.ResponseHelper;
import com.mulesoft.connectors.internal.helpers.TokenHelper;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseUtils.class);

    public static Result<InputStream, LLMResponseAttributes> processResponse(String response, ChatCompletionBase configuration, boolean isToolsResponse) throws Exception {
        JSONArray functionCalls;
        JSONArray toolsCallAnthropic;
        String provider = ProviderUtils.getProviderByModel(configuration.getModelName());
        JSONObject root = new JSONObject(response);
        ResponseInfo responseInfo = ResponseUtils.extractResponseInfo(root, configuration);
        String content = null;
        JSONArray toolCalls = new JSONArray();
        if (isToolsResponse && responseInfo.message.has("tool_calls")) {
            toolCalls = ResponseUtils.processToolCalls(responseInfo.message.getJSONArray("tool_calls"));
        }
        if (isToolsResponse && root.has("tool_calls")) {
            toolCalls = ResponseUtils.processToolCalls(root.getJSONArray("tool_calls"));
        }
        if (isToolsResponse && ProviderUtils.isAnthropic(configuration) && !(toolsCallAnthropic = ResponseUtils.extractAnthropicToolCalls(root.getJSONArray("content"))).isEmpty()) {
            responseInfo.message.put("tool_calls", (Object)toolsCallAnthropic);
        }
        if (isToolsResponse && "Google".equalsIgnoreCase(provider) && !(functionCalls = ResponseUtils.extractVertexAIFunctionCalls(root)).isEmpty()) {
            responseInfo.message.put("tool_calls", (Object)functionCalls);
        }
        if (ProviderUtils.isCohere(configuration)) {
            JSONObject firstContent;
            JSONArray contentArray;
            JSONArray jSONArray = contentArray = responseInfo.message.has("content") && !responseInfo.message.isNull("content") ? responseInfo.message.getJSONArray("content") : null;
            if (contentArray != null && contentArray.length() > 0 && (firstContent = contentArray.getJSONObject(0)).has("text") && !firstContent.isNull("text")) {
                content = firstContent.getString("text");
            }
        } else {
            content = "Google".equalsIgnoreCase(provider) ? (responseInfo.message.has("text") && !responseInfo.message.isNull("text") ? responseInfo.message.getString("text") : null) : (responseInfo.message.has("content") && !responseInfo.message.isNull("content") ? responseInfo.message.getString("content") : null);
        }
        TokenUsage tokenUsage = TokenHelper.parseUsageFromResponse(response);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("response", (Object)content);
        if (isToolsResponse) {
            JSONArray finalToolCalls = toolCalls;
            if (responseInfo.message.has("tool_calls") && !responseInfo.message.getJSONArray("tool_calls").isEmpty()) {
                finalToolCalls = responseInfo.message.getJSONArray("tool_calls");
            }
            jsonObject.put("tools", (Object)finalToolCalls);
        }
        HashMap<String, String> responseAttributes = new HashMap<String, String>();
        responseAttributes.put("finish_reason", responseInfo.finishReason);
        responseAttributes.put("model", responseInfo.model);
        responseAttributes.put("id", responseInfo.id);
        return ResponseHelper.createLLMResponse(jsonObject.toString(), tokenUsage, responseAttributes);
    }

    public static Result<InputStream, LLMResponseAttributes> processLLMResponse(String response, ChatCompletionBase configuration) throws Exception {
        return ResponseUtils.processResponse(response, configuration, false);
    }

    public static Result<InputStream, LLMResponseAttributes> processToolsResponse(String response, ChatCompletionBase configuration) throws Exception {
        return ResponseUtils.processResponse(response, configuration, true);
    }

    private static ResponseInfo extractResponseInfo(JSONObject root, ChatCompletionBase configuration) {
        ResponseInfo info = new ResponseInfo();
        String provider = ProviderUtils.getProviderByModel(configuration.getModelName());
        String string = info.model = !"AI21LABS".equals(configuration.getInferenceType()) && !"COHERE".equals(configuration.getInferenceType()) && !"VERTEX_AI_EXPRESS".equals(configuration.getInferenceType()) && !"VERTEX_AI".equals(configuration.getInferenceType()) && (!"VERTEX_AI".equals(configuration.getInferenceType()) || !"Anthropic".equalsIgnoreCase(provider)) ? root.getString("model") : configuration.getModelName();
        info.id = ProviderUtils.isOllama(configuration) ? null : ((ProviderUtils.isVertexAIExpress(configuration) || ProviderUtils.isVertexAI(configuration)) && !"Anthropic".equalsIgnoreCase(provider) && !"Meta".equalsIgnoreCase(provider) ? root.getString("responseId") : root.getString("id"));
        info.message = new JSONObject();
        if (ProviderUtils.isOllama(configuration)) {
            info.message = root.getJSONObject("message");
            info.finishReason = root.getString("done_reason");
        } else if (ProviderUtils.isCohere(configuration)) {
            info.message = root.getJSONObject("message");
            info.finishReason = root.getString("finish_reason");
        } else if (ProviderUtils.isAnthropic(configuration) || "Anthropic".equalsIgnoreCase(provider)) {
            info.finishReason = root.getString("stop_reason");
            if (root.has("content") && root.getJSONArray("content").length() > 0) {
                JSONArray contentArray = root.getJSONArray("content");
                for (int i = 0; i < contentArray.length(); ++i) {
                    JSONObject contentItem = contentArray.getJSONObject(i);
                    if (!"text".equals(contentItem.getString("type")) || !info.text.isEmpty()) continue;
                    info.text = contentItem.getString("text");
                    break;
                }
            }
            info.message = new JSONObject();
            info.message.put("content", (Object)info.text);
        } else if ((ProviderUtils.isVertexAIExpress(configuration) || ProviderUtils.isVertexAI(configuration)) && !"Meta".equalsIgnoreCase(provider)) {
            JSONArray candidatesArray = root.getJSONArray("candidates");
            if (candidatesArray.length() > 0) {
                JSONObject firstCandidate = candidatesArray.getJSONObject(0);
                info.finishReason = firstCandidate.optString("finishReason", "Unknown");
                JSONObject content = firstCandidate.getJSONObject("content");
                JSONArray partsArray = content.getJSONArray("parts");
                info.message = partsArray.getJSONObject(0);
            } else {
                LOGGER.debug("No candidates found in the response from provider: {}", (Object)configuration.getInferenceType());
            }
        } else {
            JSONArray choicesArray = root.getJSONArray("choices");
            JSONObject firstChoice = choicesArray.getJSONObject(0);
            info.finishReason = ProviderUtils.isNvidia(configuration) ? "" : firstChoice.getString("finish_reason");
            info.message = firstChoice.getJSONObject("message");
        }
        return info;
    }

    private static JSONArray extractVertexAIFunctionCalls(JSONObject root) {
        JSONArray functionCalls = new JSONArray();
        if (!root.has("candidates")) {
            return functionCalls;
        }
        JSONArray candidates = root.getJSONArray("candidates");
        for (int i = 0; i < candidates.length(); ++i) {
            JSONObject content;
            JSONObject candidate = candidates.getJSONObject(i);
            if (!candidate.has("content") || !(content = candidate.getJSONObject("content")).has("parts")) continue;
            JSONArray parts = content.getJSONArray("parts");
            for (int j = 0; j < parts.length(); ++j) {
                JSONObject part = parts.getJSONObject(j);
                if (!part.has("functionCall")) continue;
                functionCalls.put((Object)part.getJSONObject("functionCall"));
            }
        }
        return functionCalls;
    }

    private static JSONArray extractAnthropicToolCalls(JSONArray contentArray) {
        JSONArray toolCalls = new JSONArray();
        for (int i = 0; i < contentArray.length(); ++i) {
            JSONObject contentItem = contentArray.getJSONObject(i);
            String type = contentItem.getString("type");
            if (!"tool_use".equals(type)) continue;
            JSONObject functionObject = new JSONObject();
            functionObject.put("name", (Object)contentItem.getString("name"));
            functionObject.put("arguments", (Object)contentItem.getJSONObject("input"));
            JSONObject toolItem = new JSONObject();
            toolItem.put("function", (Object)functionObject);
            toolItem.put("id", (Object)contentItem.getString("id"));
            toolItem.put("type", (Object)"function");
            toolCalls.put((Object)toolItem);
        }
        return toolCalls;
    }

    private static JSONArray processToolCalls(JSONArray toolCalls) {
        JSONArray processedToolCalls = new JSONArray();
        for (int i = 0; i < toolCalls.length(); ++i) {
            JSONObject functionObject;
            JSONObject toolCall = toolCalls.getJSONObject(i);
            if (toolCall.has("function") && (functionObject = toolCall.getJSONObject("function")).has("arguments")) {
                try {
                    JSONObject arguments = new JSONObject(functionObject.getString("arguments"));
                    functionObject.put("arguments", (Object)arguments);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to parse function arguments as JSON: {}", (Object)e.getMessage());
                }
            }
            processedToolCalls.put((Object)toolCall);
        }
        return processedToolCalls;
    }

    public static Result<InputStream, LLMResponseAttributes> processImageGenResponse(String response, ChatCompletionBase configuration) throws Exception {
        JSONArray dataArray;
        JSONObject root = new JSONObject(response);
        JSONObject jsonObject = new JSONObject();
        HashMap<String, String> responseAttributes = new HashMap<String, String>();
        if ((ProviderUtils.isOpenAI(configuration) || ProviderUtils.isHuggingFace(configuration) || ProviderUtils.isStabilityAI(configuration) || ProviderUtils.isXAI(configuration)) && root.has("data") && (dataArray = root.getJSONArray("data")).length() > 0) {
            JSONObject firstData = dataArray.getJSONObject(0);
            String b64Json = firstData.optString("b64_json", null);
            String revisedPrompt = firstData.optString("revised_prompt", null);
            if (revisedPrompt != null) {
                responseAttributes.put("Prompt_used", revisedPrompt);
            }
            jsonObject.put("response", (Object)b64Json);
        }
        responseAttributes.put("model", configuration.getModelName());
        return ResponseHelper.createLLMResponse(jsonObject.toString(), null, responseAttributes);
    }

    public static String encodeImageToBase64(byte[] imageBytes) {
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    private static class ResponseInfo {
        String model;
        String id;
        JSONObject message;
        String finishReason;
        String text = "";

        private ResponseInfo() {
        }
    }
}

