/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.api.delegate;

import com.mulesoft.connectors.internal.api.delegate.MistralAIModeration;
import com.mulesoft.connectors.internal.api.delegate.OpenAIModeration;
import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.config.ModerationConfig;
import com.mulesoft.connectors.internal.connection.types.ModerationBase;
import com.mulesoft.connectors.internal.exception.InferenceErrorType;
import com.mulesoft.connectors.internal.utils.ConnectionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Moderation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Moderation.class);
    protected final ModerationConfig configuration;
    protected final ModerationBase connection;
    private static Moderation instance;

    protected Moderation(ModerationConfig configuration, ModerationBase connection) {
        this.configuration = configuration;
        this.connection = connection;
    }

    public static Moderation getInstance(ModerationConfig configuration, ModerationBase connection) {
        if (instance == null) {
            instance = Moderation.findInstance(configuration, connection);
        }
        if (instance == null) {
            throw new IllegalArgumentException("No moderation provider found for the given configuration");
        }
        return instance;
    }

    private static Moderation findInstance(ModerationConfig configuration, ModerationBase connection) {
        switch (connection.getInferenceType()) {
            case "MISTRAL_AI": {
                return new MistralAIModeration(configuration, connection);
            }
            case "OPENAI": {
                return new OpenAIModeration(configuration, connection);
            }
        }
        return null;
    }

    public Result<InputStream, LLMResponseAttributes> moderate(InputStream text) {
        String payload = this.getRequestPayload(text, null);
        LOGGER.debug("Moderation payload that will be sent to the LLM {}", (Object)payload);
        String response = this.getResponsePayload(payload);
        LOGGER.debug("Moderation service - response from LLM: {}", (Object)response);
        return this.processResponse(response);
    }

    protected abstract JSONObject handleModelSpecificRequestPayload(JSONObject var1, Object var2, Object var3);

    protected abstract String getTextInputAttributeName();

    public abstract String getAPIUrl();

    protected abstract boolean isFlagged(JSONObject var1);

    protected List<Map<String, Double>> getCategories(JSONObject llmResponseObject) {
        JSONArray results = llmResponseObject.getJSONArray("results");
        ArrayList<Map<String, Double>> returnValueList = new ArrayList<Map<String, Double>>();
        for (Object result : results) {
            HashMap<String, Double> categoriesMap = new HashMap<String, Double>();
            JSONObject resultObject = (JSONObject)result;
            JSONObject categoriesObject = resultObject.getJSONObject("categories");
            JSONObject categoryScoresObject = resultObject.getJSONObject("category_scores");
            for (String key : categoriesObject.keySet()) {
                categoriesMap.put(key, categoryScoresObject.getDouble(key));
            }
            returnValueList.add(categoriesMap);
        }
        return returnValueList;
    }

    protected String getRequestPayload(InputStream text, InputStream images) {
        String inputString = Moderation.convertStreamToString(text);
        JSONObject payload = new JSONObject();
        if (Moderation.isJsonArray(inputString)) {
            JSONArray inputArray = new JSONArray(inputString);
            payload.put(this.getTextInputAttributeName(), (Object)inputArray);
        } else {
            JSONObject inputObject = new JSONObject("{ \"prompt\": " + inputString + " }");
            payload.put(this.getTextInputAttributeName(), inputObject.get("prompt"));
        }
        payload = this.handleModelSpecificRequestPayload(payload, text, images);
        return payload.toString();
    }

    protected String getResponsePayload(String requestPayload) {
        try {
            URL moderationURL = new URL(this.getAPIUrl());
            if (this.connection == null) {
                throw new IllegalStateException("Moderation connection is not initialized");
            }
            return ConnectionUtils.executeREST(moderationURL, this.connection, requestPayload);
        }
        catch (Exception e) {
            LOGGER.error("Error in moderation: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException("MODERATION ERROR", (ErrorTypeDefinition)InferenceErrorType.TEXT_MODERATION, (Throwable)e);
        }
    }

    protected Result<InputStream, LLMResponseAttributes> processResponse(String llmResponse) throws ModuleException {
        try {
            JSONObject responseObject = new JSONObject();
            JSONObject llmResponseObject = new JSONObject(llmResponse);
            responseObject.put("flagged", this.isFlagged(llmResponseObject));
            List<Map<String, Double>> categories = this.getCategories(llmResponseObject);
            JSONArray categoriesArray = new JSONArray();
            categories.forEach(category -> categoriesArray.put((Object)new JSONObject(category)));
            responseObject.put("categories", (Object)categoriesArray);
            return Result.builder().attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)responseObject.toString(), (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
        }
        catch (Exception e) {
            LOGGER.error("Error processing moderation response: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException("MODERATION ERROR", (ErrorTypeDefinition)InferenceErrorType.TEXT_MODERATION, (Throwable)e);
        }
    }

    protected static boolean isJsonArray(String input) {
        try {
            new JSONArray(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected static boolean isValidJson(String input) {
        try {
            new JSONObject(input);
            return true;
        }
        catch (Exception e) {
            return Moderation.isJsonArray(input);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static String convertStreamToString(InputStream inputStream) {
        if (inputStream == null) {
            return "";
        }
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(reader);){
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                string = stringBuilder.toString().trim();
            }
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Error converting stream to string. Returning empty string", (Throwable)e);
            return "";
        }
    }
}

