/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.connection.types;

import com.mulesoft.connectors.internal.api.proxy.HttpProxyConfig;
import com.mulesoft.connectors.internal.connection.types.ImageGeneration;
import com.mulesoft.connectors.internal.models.images.ModelNameProvider;
import com.mulesoft.connectors.internal.models.images.ModelTypeProvider;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

@Alias(value="image-generation")
@DisplayName(value="Image Generation Model")
public class ImageGenerationProvider
implements CachedConnectionProvider<ImageGeneration>,
Startable,
Stoppable {
    private HttpClient httpClient;
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Inference Type")
    @OfValues(value=ModelTypeProvider.class)
    private String inferenceType;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="API Key")
    private String apiKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=ModelNameProvider.class)
    @Optional(defaultValue="dall-e-3")
    private String modelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Timeout (milliseconds)")
    @Optional(defaultValue="#['600000']")
    private int timeout;
    @Parameter
    @Placement(order=2, tab="Advanced")
    @Optional
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Placement(tab="Proxy", order=1)
    private HttpProxyConfig proxyConfig;

    public void setInferenceType(String inferenceType) {
        this.inferenceType = inferenceType;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ImageGeneration connect() throws ConnectionException {
        return new ImageGeneration(this.httpClient, this.timeout, this.inferenceType, this.apiKey, this.modelName);
    }

    public void disconnect(ImageGeneration imageGeneration) {
    }

    public ConnectionValidationResult validate(ImageGeneration imageGeneration) {
        try {
            imageGeneration.validate();
            return ConnectionValidationResult.success();
        }
        catch (ConnectionException e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void start() throws MuleException {
        HttpClientConfiguration config = this.createClientConfiguration();
        this.httpClient = this.httpService.getClientFactory().create(config);
        this.httpClient.start();
    }

    private HttpClientConfiguration createClientConfiguration() {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder().setName(this.configName);
        if (null != this.tlsContext) {
            builder.setTlsContextFactory(this.tlsContext);
        } else {
            builder.setTlsContextFactory(TlsContextFactory.builder().buildDefault());
        }
        if (this.proxyConfig != null) {
            builder.setProxyConfig((ProxyConfig)this.proxyConfig);
        }
        return builder.build();
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }
}

