/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.connection.types;

import com.mulesoft.connectors.internal.api.proxy.HttpProxyConfig;
import com.mulesoft.connectors.internal.connection.types.ModerationBase;
import com.mulesoft.connectors.internal.models.moderation.ModerationNameProvider;
import com.mulesoft.connectors.internal.models.moderation.ModerationTypeProvider;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

@Alias(value="moderation-model")
@DisplayName(value="Moderation Model")
public class ModerationProvider
implements CachedConnectionProvider<ModerationBase>,
Startable,
Stoppable {
    private HttpClient httpClient;
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Parameter
    @Placement(order=1, tab="General")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Inference Type")
    @OfValues(value=ModerationTypeProvider.class)
    private String inferenceType;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="API Key")
    private String apiKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=ModerationNameProvider.class)
    private String modelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Timeout (milliseconds)")
    @Optional(defaultValue="#['600000']")
    private int timeout;
    @Parameter
    @Placement(order=2, tab="Advanced")
    @Optional
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Placement(tab="Proxy", order=1)
    private HttpProxyConfig proxyConfig;

    public void setInferenceType() {
        this.inferenceType = this.inferenceType;
    }

    public void setApiKey() {
        this.apiKey = this.apiKey;
    }

    public void setModelName() {
        this.modelName = this.modelName;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ModerationBase connect() throws ConnectionException {
        return new ModerationBase(this.httpClient, this.timeout, this.inferenceType, this.apiKey, this.modelName);
    }

    public void disconnect(ModerationBase moderation) {
    }

    public ConnectionValidationResult validate(ModerationBase moderation) {
        try {
            moderation.validate();
            return ConnectionValidationResult.success();
        }
        catch (ConnectionException e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void start() throws MuleException {
        HttpClientConfiguration config = this.createClientConfiguration();
        this.httpClient = this.httpService.getClientFactory().create(config);
        this.httpClient.start();
    }

    private HttpClientConfiguration createClientConfiguration() {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder().setName(this.configName);
        if (null != this.tlsContext) {
            builder.setTlsContextFactory(this.tlsContext);
        } else {
            builder.setTlsContextFactory(TlsContextFactory.builder().buildDefault());
        }
        if (this.proxyConfig != null) {
            builder.setProxyConfig((ProxyConfig)this.proxyConfig);
        }
        return builder.build();
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }
}

