/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.models.moderation;

import com.mulesoft.connectors.internal.exception.error.ConfigValidationException;
import java.util.Arrays;
import java.util.stream.Stream;

public enum ModerationModelType {
    OPENAI("OPENAI", ModerationModelType.getOpenAIModerationModelNameStream()),
    MISTRAL_AI("MISTRAL_AI", ModerationModelType.getMistralAIModerationModelNameStream());

    private final String value;
    private final Stream<String> modelNameStream;

    private ModerationModelType(String value, Stream<String> modelNameStream) {
        this.value = value;
        this.modelNameStream = modelNameStream;
    }

    public String getValue() {
        return this.value;
    }

    public Stream<String> getModelNameStream() {
        return this.modelNameStream;
    }

    private static Stream<String> getOpenAIModerationModelNameStream() {
        return Arrays.stream(OpenAIModerationModelName.values()).map(String::valueOf);
    }

    private static Stream<String> getMistralAIModerationModelNameStream() {
        return Arrays.stream(MistralIModerationModelName.values()).map(String::valueOf);
    }

    public static ModerationModelType fromValue(String value) {
        return Arrays.stream(ModerationModelType.values()).filter(moderationModelType -> moderationModelType.value.equals(value)).findFirst().orElseThrow(() -> new ConfigValidationException("Unsupported Moderation Model Type: " + value));
    }

    static enum OpenAIModerationModelName {
        text_moderation_latest_legacy("text-moderation-latest"),
        omni_moderation_latest("omni-moderation-latest");

        private final String value;

        private OpenAIModerationModelName(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    static enum MistralIModerationModelName {
        mistral_moderation_latest("mistral-moderation-latest");

        private final String value;

        private MistralIModerationModelName(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

