/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operations;

import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.config.TextGenerationConfig;
import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.exception.InferenceErrorType;
import com.mulesoft.connectors.internal.utils.ConnectionUtils;
import com.mulesoft.connectors.internal.utils.PayloadUtils;
import com.mulesoft.connectors.internal.utils.ResponseUtils;
import java.io.InputStream;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextGenerationOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextGenerationOperations.class);
    private static final String ERROR_MSG_FORMAT = "%s result error";

    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-completions")
    @DisplayName(value="[Chat] Completions")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Native chat completion operation")
    public Result<InputStream, LLMResponseAttributes> chatCompletion(@Config TextGenerationConfig configuration, @Connection ChatCompletionBase connection, @Content InputStream messages) throws ModuleException {
        try {
            JSONArray messagesArray = PayloadUtils.parseInputStreamToJsonArray(messages);
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(connection);
            LOGGER.debug("Chatting with {}", (Object)chatCompUrl);
            JSONObject payload = PayloadUtils.buildPayload(connection, messagesArray, null);
            String response = ConnectionUtils.executeREST(chatCompUrl, connection, payload.toString());
            LOGGER.debug("Chat completions result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, connection);
        }
        catch (Exception e) {
            LOGGER.error("Error in chat completions: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Chat completions"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-answer-prompt")
    @DisplayName(value="[Chat] Answer Prompt")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Simple chat answer prompt")
    public Result<InputStream, LLMResponseAttributes> chatAnswerPrompt(@Config TextGenerationConfig configuration, @Connection ChatCompletionBase connection, @Content String prompt) throws ModuleException {
        try {
            JSONObject payload = PayloadUtils.buildChatAnswerPromptPayload(connection, prompt);
            LOGGER.debug("payload sent to the LLM {}", (Object)payload.toString());
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(connection);
            LOGGER.debug("Chat answer prompt Url: {}", (Object)chatCompUrl.toString());
            String response = ConnectionUtils.executeREST(chatCompUrl, connection, payload.toString());
            LOGGER.debug("Chat answer prompt result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, connection);
        }
        catch (Exception e) {
            LOGGER.error("Error in chat answer prompt: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Chat answer prompt"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Agent-define-prompt-template")
    @DisplayName(value="[Agent] Define Prompt Template")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Define a prompt template with instructions, and data ")
    public Result<InputStream, LLMResponseAttributes> promptTemplate(@Config TextGenerationConfig configuration, @Connection ChatCompletionBase connection, @Content String template, @Content String instructions, @Content(primary=true) String data) throws ModuleException {
        try {
            JSONObject payload = PayloadUtils.buildPromptTemplatePayload(connection, template, instructions, data);
            LOGGER.debug("payload sent to the LLM {}", (Object)payload.toString());
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(connection);
            String response = ConnectionUtils.executeREST(chatCompUrl, connection, payload.toString());
            LOGGER.debug("Agent define prompt template result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, connection);
        }
        catch (Exception e) {
            LOGGER.error("Error in agent define prompt template: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Agent define prompt template"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Tools-native-template")
    @DisplayName(value="[Tools] Native Template (Reasoning only)")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Define a prompt template with instructions, data and tools")
    public Result<InputStream, LLMResponseAttributes> toolsTemplate(@Config TextGenerationConfig configuration, @Connection ChatCompletionBase connection, @Content String template, @Content String instructions, @Content(primary=true) String data, @Content @Summary(value="JSON Array defining the tools set to be used in the template so that the LLM can use them if required") InputStream tools) throws ModuleException {
        try {
            JSONObject payload = PayloadUtils.buildToolsTemplatePayload(configuration, connection, template, instructions, data, tools);
            LOGGER.debug("payload sent to the LLM {}", (Object)payload.toString());
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(connection);
            String response = ConnectionUtils.executeREST(chatCompUrl, connection, payload.toString());
            LOGGER.debug("Tools use native template result {}", (Object)response);
            return ResponseUtils.processToolsResponse(response, connection);
        }
        catch (Exception e) {
            LOGGER.error("Error in tools use native template: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Tools use native template"), (ErrorTypeDefinition)InferenceErrorType.CHAT_COMPLETION, (Throwable)e);
        }
    }
}

