/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.google.auth.oauth2.GoogleCredentials;
import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.connection.ModerationImageGenerationBase;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import com.mulesoft.connectors.internal.utils.ResponseUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtils.class);
    private static HttpClient httpClient;

    public static HttpRequest buildHttpRequest(URL url, ChatCompletionBase connection) throws IOException, TimeoutException {
        HttpRequestBuilder requestBuilder = HttpRequest.builder();
        Object finalUri = url.toString();
        if ("VERTEX_AI_EXPRESS".equalsIgnoreCase(connection.getInferenceType())) {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("key", connection.getApiKey());
            finalUri = url.toString() + "?" + ConnectionUtils.getQueryParams(queryParams);
        }
        LOGGER.debug("Request path: {}", finalUri);
        ((HttpRequestBuilder)((HttpRequestBuilder)requestBuilder.uri((String)finalUri).method("POST").addHeader("Content-Type", "application/json")).addHeader("User-Agent", "Mozilla/5.0")).addHeader("Accept", "application/json");
        switch (connection.getInferenceType()) {
            case "ANTHROPIC": {
                ((HttpRequestBuilder)requestBuilder.addHeader("x-api-key", connection.getApiKey())).addHeader("anthropic-version", "2023-06-01");
                break;
            }
            case "PORTKEY": {
                ((HttpRequestBuilder)requestBuilder.addHeader("x-portkey-api-key", connection.getApiKey())).addHeader("x-portkey-virtual-key", connection.getVirtualKey());
                break;
            }
            case "AZURE_OPENAI": {
                requestBuilder.addHeader("api-key", connection.getApiKey());
                break;
            }
            case "VERTEX_AI_EXPRESS": {
                break;
            }
            case "AZURE_AI_FOUNDRY": {
                requestBuilder.addHeader("api-key", connection.getApiKey());
                break;
            }
            case "IBM_WATSON": {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("grant_type", "urn:ibm:params:oauth:grant-type:apikey");
                params.put("apikey", connection.getApiKey());
                URL tokenUrl = new URL("https://iam.cloud.ibm.com/identity/token");
                String response = ConnectionUtils.executeTokenRequest(tokenUrl, connection, params);
                JSONObject jsonResponse = new JSONObject(response);
                String accessToken = jsonResponse.getString("access_token");
                requestBuilder.addHeader("Authorization", "Bearer " + accessToken);
                break;
            }
            case "VERTEX_AI": {
                requestBuilder.addHeader("Authorization", "Bearer " + ConnectionUtils.getAccessTokenFromServiceAccountKey(connection));
                break;
            }
            default: {
                requestBuilder.addHeader("Authorization", "Bearer " + connection.getApiKey());
            }
        }
        return requestBuilder.build();
    }

    public static HttpRequestOptions getRequestOptions(ChatCompletionBase connection) {
        return HttpRequestOptions.builder().responseTimeout(String.valueOf(connection.getTimeout()) != null ? Integer.parseInt(String.valueOf(connection.getTimeout())) : 600000).followsRedirect(true).build();
    }

    public static URL getConnectionURLChatCompletion(ChatCompletionBase connection) throws MalformedURLException {
        switch (connection.getInferenceType()) {
            case "PORTKEY": {
                return new URL("https://api.portkey.ai/v1/chat/completions");
            }
            case "GROQ": {
                return new URL("https://api.groq.com/openai/v1/chat/completions");
            }
            case "HUGGING_FACE": {
                return new URL("https://router.huggingface.co/hf-inference/models/" + connection.getModelName() + "/v1/chat/completions");
            }
            case "OPENROUTER": {
                return new URL("https://openrouter.ai/api/v1/chat/completions");
            }
            case "GITHUB": {
                return new URL("https://models.inference.ai.azure.com/chat/completions");
            }
            case "OLLAMA": {
                return new URL(connection.getOllamaUrl() + "/chat");
            }
            case "XINFERENCE": {
                return new URL(connection.getxinferenceUrl() + "/chat/completions");
            }
            case "CEREBRAS": {
                return new URL("https://api.cerebras.ai/v1/chat/completions");
            }
            case "NVIDIA": {
                return new URL("https://integrate.api.nvidia.com/v1/chat/completions");
            }
            case "FIREWORKS": {
                return new URL("https://api.fireworks.ai/inference/v1/chat/completions");
            }
            case "TOGETHER": {
                return new URL("https://api.together.xyz/v1/chat/completions");
            }
            case "DEEPINFRA": {
                return new URL("https://api.deepinfra.com/v1/openai/chat/completions");
            }
            case "PERPLEXITY": {
                return new URL("https://api.perplexity.ai/chat/completions");
            }
            case "XAI": {
                return new URL("https://api.x.ai/v1/chat/completions");
            }
            case "OPENAI": {
                return new URL("https://api.openai.com/v1/chat/completions");
            }
            case "MISTRAL": {
                return new URL("https://api.mistral.ai/v1/chat/completions");
            }
            case "ANTHROPIC": {
                return new URL("https://api.anthropic.com/v1/messages");
            }
            case "AI21LABS": {
                return new URL("https://api.ai21.com/studio/v1/chat/completions");
            }
            case "COHERE": {
                return new URL("https://api.cohere.com/v2/chat");
            }
            case "AZURE_OPENAI": {
                String urlStr = "https://{resource-name}.openai.azure.com/openai/deployments/{deployment-id}/chat/completions?api-version=2024-10-21";
                urlStr = urlStr.replace("{resource-name}", connection.getAzureOpenaiResourceName()).replace("{deployment-id}", connection.getAzureOpenaiDeploymentId());
                return new URL(urlStr);
            }
            case "VERTEX_AI_EXPRESS": {
                String vertexAIExpressUrlStr = "https://aiplatform.googleapis.com/v1/publishers/google/models/{MODEL_ID}:generateContent";
                vertexAIExpressUrlStr = vertexAIExpressUrlStr.replace("{MODEL_ID}", connection.getModelName());
                return new URL(vertexAIExpressUrlStr);
            }
            case "VERTEX_AI": {
                String provider = ProviderUtils.getProviderByModel(connection.getModelName());
                String vertexAIUrlStr = "";
                switch (provider) {
                    case "Google": {
                        vertexAIUrlStr = "https://{LOCATION_ID}-aiplatform.googleapis.com/v1/projects/{PROJECT_ID}/locations/{LOCATION_ID}/publishers/google/models/{MODEL_ID}:generateContent";
                        vertexAIUrlStr = vertexAIUrlStr.replace("{LOCATION_ID}", connection.getVertexAILocationId()).replace("{PROJECT_ID}", connection.getVertexAIProjectId()).replace("{MODEL_ID}", connection.getModelName());
                        return new URL(vertexAIUrlStr);
                    }
                    case "Anthropic": {
                        vertexAIUrlStr = "https://{LOCATION_ID}-aiplatform.googleapis.com/v1/projects/{PROJECT_ID}/locations/{LOCATION_ID}/publishers/anthropic/models/{MODEL_ID}:rawPredict";
                        vertexAIUrlStr = vertexAIUrlStr.replace("{LOCATION_ID}", connection.getVertexAILocationId()).replace("{PROJECT_ID}", connection.getVertexAIProjectId()).replace("{MODEL_ID}", connection.getModelName());
                        return new URL(vertexAIUrlStr);
                    }
                    case "Meta": {
                        vertexAIUrlStr = "https://{LOCATION_ID}-aiplatform.googleapis.com/v1beta1/projects/{PROJECT_ID}/locations/{LOCATION_ID}/endpoints/openapi/chat/completions";
                        vertexAIUrlStr = vertexAIUrlStr.replace("{LOCATION_ID}", connection.getVertexAILocationId()).replace("{PROJECT_ID}", connection.getVertexAIProjectId());
                        return new URL(vertexAIUrlStr);
                    }
                }
                LOGGER.error("Unknown provider. Skipping... {}", (Object)provider);
            }
            case "AZURE_AI_FOUNDRY": {
                String aifurlStr = "https://{resource-name}.services.ai.azure.com/models/chat/completions?api-version={api-version}";
                aifurlStr = aifurlStr.replace("{resource-name}", connection.getAzureAIFoundryResourceName()).replace("{api-version}", connection.getAzureAIFoundryApiVersion());
                return new URL(aifurlStr);
            }
            case "GPT4ALL": {
                return new URL(connection.getGpt4All() + "/chat/completions");
            }
            case "LMSTUDIO": {
                return new URL(connection.getLmStudio() + "/chat/completions");
            }
            case "DOCKER_MODELS": {
                return new URL(connection.getDockerModelUrl() + "/engines/llama.cpp/v1/chat/completions");
            }
            case "DEEPSEEK": {
                return new URL("https://api.deepseek.com/chat/completions");
            }
            case "ZHIPU_AI": {
                return new URL("https://open.bigmodel.cn/api/paas/v4/chat/completions");
            }
            case "OPENAI_COMPATIBLE_ENDPOINT": {
                return new URL(connection.getOpenAICompatibleURL() + "/chat/completions");
            }
            case "IBM_WATSON": {
                String ibmwurlStr = "https://us-south.ml.cloud.ibm.com/ml/v1/text/chat?version={api-version}";
                ibmwurlStr = ibmwurlStr.replace("{api-version}", connection.getIBMWatsonApiVersion());
                return new URL(ibmwurlStr);
            }
            case "DATABRICKS": {
                Object dBricksUrlStr = connection.getDataBricksModelUrl() + "/serving-endpoints/{model_name}/invocations";
                dBricksUrlStr = ((String)dBricksUrlStr).replace("{model_name}", connection.getModelName());
                return new URL((String)dBricksUrlStr);
            }
        }
        throw new MalformedURLException("Unsupported inference type: " + connection.getInferenceType());
    }

    public static URL getConnectionURLImageGeneration(ChatCompletionBase connection) throws MalformedURLException {
        switch (connection.getInferenceType()) {
            case "OPENAI": {
                return new URL("https://api.openai.com/v1/images/generations");
            }
            case "HUGGING_FACE": {
                return new URL("https://router.huggingface.co/hf-inference/models/" + connection.getModelName());
            }
            case "STABILITY_AI": {
                return new URL("https://api.stability.ai/v2beta/stable-image/generate/sd3");
            }
            case "XAI": {
                return new URL("https://api.x.ai/v1/images/generations");
            }
        }
        throw new MalformedURLException("Unsupported inference type: " + connection.getInferenceType());
    }

    public static String executeREST(URL resourceUrl, ChatCompletionBase connection, String payload) throws IOException, TimeoutException {
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Resource URL cannot be null");
        }
        HttpRequest initialRequest = ConnectionUtils.buildHttpRequest(resourceUrl, connection);
        MultiMap headersMultiMap = initialRequest.getHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMultiMap.forEach((key, values) -> headersMap.put((String)key, String.join((CharSequence)",", values)));
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder().uri(initialRequest.getUri()).method(initialRequest.getMethod()).entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes(StandardCharsets.UTF_8)));
        headersMap.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).addHeader(arg_0, arg_1));
        HttpRequest finalRequest = builder.build();
        HttpRequestOptions options = ConnectionUtils.getRequestOptions(connection);
        HttpClient httpClient = connection.getHttpClient();
        if (httpClient == null) {
            throw new IllegalStateException("HttpClient is not initialized");
        }
        HttpResponse response = httpClient.send(finalRequest, options);
        return ConnectionUtils.processResponse(response);
    }

    public static String executeREST(URL resourceUrl, ModerationImageGenerationBase connection, String payload) throws IOException, TimeoutException {
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Resource URL cannot be null");
        }
        ChatCompletionBase baseConnection = ProviderUtils.convertToBaseConnection(connection);
        HttpRequest initialRequest = ConnectionUtils.buildHttpRequest(resourceUrl, baseConnection);
        MultiMap headersMultiMap = initialRequest.getHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMultiMap.forEach((key, values) -> headersMap.put((String)key, String.join((CharSequence)",", values)));
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder().uri(initialRequest.getUri()).method(initialRequest.getMethod()).entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes(StandardCharsets.UTF_8)));
        headersMap.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).addHeader(arg_0, arg_1));
        HttpRequest finalRequest = builder.build();
        HttpRequestOptions options = ConnectionUtils.getRequestOptions(baseConnection);
        HttpClient httpClient = connection.getHttpClient();
        if (httpClient == null) {
            throw new IllegalStateException("HttpClient is not initialized");
        }
        HttpResponse response = httpClient.send(finalRequest, options);
        return ConnectionUtils.processResponse(response);
    }

    public static String executeRestImageGeneration(URL resourceUrl, ChatCompletionBase connection, String payload) throws IOException, TimeoutException {
        String response = "";
        response = ProviderUtils.isHuggingFace(connection) ? ConnectionUtils.executeRESTHuggingFaceImage(resourceUrl, connection, payload.toString()) : (ProviderUtils.isStabilityAI(connection) ? ConnectionUtils.executeRESTStabilityAIImage(resourceUrl, connection, payload) : ConnectionUtils.executeREST(resourceUrl, connection, payload.toString()));
        return response;
    }

    public static String executeRESTHuggingFaceImage(URL resourceUrl, ChatCompletionBase connection, String payload) throws IOException, TimeoutException {
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Resource URL cannot be null");
        }
        HttpRequest initialRequest = ConnectionUtils.buildHttpRequest(resourceUrl, connection);
        MultiMap headersMultiMap = initialRequest.getHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMultiMap.forEach((key, values) -> headersMap.put((String)key, String.join((CharSequence)",", values)));
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder().uri(initialRequest.getUri()).method(initialRequest.getMethod()).entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes(StandardCharsets.UTF_8)));
        headersMap.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).addHeader(arg_0, arg_1));
        HttpRequest finalRequest = builder.build();
        HttpRequestOptions options = ConnectionUtils.getRequestOptions(connection);
        HttpClient httpClient = connection.getHttpClient();
        if (httpClient == null) {
            throw new IllegalStateException("HttpClient is not initialized in BaseConnection");
        }
        HttpResponse response = httpClient.send(finalRequest, options);
        return ConnectionUtils.processHuggingFaceImageResponse(response, payload);
    }

    public static String executeRESTStabilityAIImage(URL resourceUrl, ChatCompletionBase connection, String payload) throws IOException, TimeoutException {
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Resource URL cannot be null");
        }
        HttpRequest initialRequest = ConnectionUtils.buildHttpRequest(resourceUrl, connection);
        MultiMap headersMultiMap = initialRequest.getHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMultiMap.forEach((key, values) -> headersMap.put((String)key, String.join((CharSequence)",", values)));
        headersMap.remove("Content-Type");
        headersMap.remove("content-type");
        JSONObject payloadJson = new JSONObject(payload);
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        byte[] promptBytes = payloadJson.getString("prompt").getBytes(StandardCharsets.UTF_8);
        parts.add(new HttpPart("prompt", promptBytes, "text/plain", promptBytes.length));
        MultipartHttpEntity entity = new MultipartHttpEntity(parts);
        HttpRequestBuilder builder = (HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(initialRequest.getUri()).method(initialRequest.getMethod()).addHeader("Content-Type", "multipart/form-data")).entity((HttpEntity)entity);
        headersMap.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).addHeader(arg_0, arg_1));
        HttpRequest finalRequest = builder.build();
        HttpRequestOptions options = ConnectionUtils.getRequestOptions(connection);
        HttpClient httpClient = connection.getHttpClient();
        if (httpClient == null) {
            throw new IllegalStateException("HttpClient is not initialized in BaseConnection");
        }
        HttpResponse response = httpClient.send(finalRequest, options);
        return ConnectionUtils.processStabilityAIImageResponse(response, payload);
    }

    private static String processResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            return new String(response.getEntity().getBytes(), StandardCharsets.UTF_8);
        }
        String errorResponse = new String(response.getEntity().getBytes(), StandardCharsets.UTF_8);
        LOGGER.error("API request failed with status code: {} and message: {}", (Object)statusCode, (Object)errorResponse);
        throw new IOException("API request failed with status code: " + statusCode + " and message: " + errorResponse);
    }

    private static String processHuggingFaceImageResponse(HttpResponse response, String payload) throws IOException {
        int statusCode = response.getStatusCode();
        JSONObject responseWrapper = new JSONObject();
        if (statusCode == 200) {
            String contentType = response.getHeaderValue("Content-Type");
            if (contentType != null && contentType.startsWith("image/")) {
                byte[] responseBytes = response.getEntity().getBytes();
                String base64Image = ResponseUtils.encodeImageToBase64(responseBytes);
                JSONObject base64Object = new JSONObject();
                base64Object.put("b64_json", (Object)base64Image);
                JSONObject revisedPrompt = new JSONObject(payload);
                base64Object.put("revised_prompt", (Object)revisedPrompt.getString("inputs"));
                JSONArray dataArray = new JSONArray();
                dataArray.put((Object)base64Object);
                responseWrapper.put("data", (Object)dataArray);
            }
            return responseWrapper.toString();
        }
        String errorResponse = new String(response.getEntity().getBytes(), StandardCharsets.UTF_8);
        LOGGER.error("API request failed with status code: {} and message: {}", (Object)statusCode, (Object)errorResponse);
        throw new IOException("API request failed with status code: " + statusCode + " and message: " + errorResponse);
    }

    private static String processStabilityAIImageResponse(HttpResponse response, String payload) throws IOException {
        int statusCode = response.getStatusCode();
        JSONObject responseWrapper = new JSONObject();
        if (statusCode == 200) {
            String base64Image;
            String responseBody = new String(response.getEntity().getBytes(), StandardCharsets.UTF_8);
            JSONObject stabilityResponse = new JSONObject(responseBody);
            String contentType = response.getHeaderValue("Content-Type");
            if (contentType != null && contentType.contains("application/json") && stabilityResponse.has("image")) {
                base64Image = stabilityResponse.getString("image");
                if (base64Image.startsWith("data:image")) {
                    base64Image = base64Image.substring(base64Image.indexOf(",") + 1);
                }
            } else {
                LOGGER.error("Unexpected response format: Content-Type is {} and response body is {}", (Object)contentType, (Object)responseBody);
                throw new IOException("Unexpected response format from Stability AI API");
            }
            LOGGER.debug("Base64 image length: {}", (Object)base64Image.length());
            JSONObject base64Object = new JSONObject();
            base64Object.put("b64_json", (Object)base64Image);
            JSONObject payloadJson = new JSONObject(payload);
            base64Object.put("revised_prompt", (Object)payloadJson.getString("prompt"));
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)base64Object);
            responseWrapper.put("data", (Object)dataArray);
            return responseWrapper.toString();
        }
        String errorResponse = new String(response.getEntity().getBytes(), StandardCharsets.UTF_8);
        LOGGER.error("API request failed with status code: {} and message: {}", (Object)statusCode, (Object)errorResponse);
        throw new IOException("API request failed with status code: " + statusCode + " and message: " + errorResponse);
    }

    public static String getQueryParams(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (query.length() > 0) {
                query.append("&");
            }
            query.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return query.toString();
    }

    public static String getAccessTokenFromServiceAccountKey(ChatCompletionBase connection) throws IOException {
        FileInputStream serviceAccountStream = new FileInputStream(connection.getVertexAIServiceAccountKey());
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)serviceAccountStream).createScoped(Collections.singletonList("https://www.googleapis.com/auth/cloud-platform"));
        credentials.refreshIfExpired();
        String token = credentials.getAccessToken().getTokenValue();
        LOGGER.debug("gcp access token {}", (Object)token);
        return token;
    }

    public static byte[] readResponseBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new byte[0];
        }
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[4096];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    public static String executeTokenRequest(URL url, ChatCompletionBase connection, Map<String, String> params) throws IOException, TimeoutException {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        String payload = ConnectionUtils.getURLEncodedData(params);
        LOGGER.debug("Token request payload: {}", (Object)payload);
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(url.toString()).method("POST").addHeader("Content-Type", "application/x-www-form-urlencoded")).addHeader("User-Agent", "Mozilla/5.0")).addHeader("Accept", "application/json")).entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes(StandardCharsets.UTF_8)));
        HttpRequest request = requestBuilder.build();
        HttpRequestOptions options = HttpRequestOptions.builder().responseTimeout(connection.getTimeout() != 0 ? connection.getTimeout() : 600000).build();
        HttpClient httpClient = connection.getHttpClient();
        if (httpClient == null) {
            throw new IllegalStateException("HttpClient is not initialized in BaseConnection");
        }
        LOGGER.debug("Executing token request to: {}", (Object)url);
        HttpResponse response = httpClient.send(request, options);
        return ConnectionUtils.processTokenResponse(response);
    }

    private static String processTokenResponse(HttpResponse response) throws IOException {
        String responseBody;
        int statusCode;
        block14: {
            statusCode = response.getStatusCode();
            HttpEntity entity = response.getEntity();
            if (entity != null && entity.getContent() != null) {
                try (InputStream content = entity.getContent();
                     ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = content.read(buffer)) != -1) {
                        byteArrayOutputStream.write(buffer, 0, bytesRead);
                    }
                    responseBody = byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
                    break block14;
                }
            }
            responseBody = "";
        }
        if (statusCode >= 200 && statusCode < 300) {
            LOGGER.debug("Token request successful, response: {}", (Object)responseBody);
            return responseBody;
        }
        LOGGER.error("Token request failed with status {}: {}", (Object)statusCode, (Object)responseBody);
        throw new IOException("Token request failed with status " + statusCode + ": " + responseBody);
    }

    private static String getURLEncodedData(Map<String, String> params) throws IOException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }
}

