/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.config.TextGenerationConfig;
import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.connection.ModerationImageGenerationBase;
import com.mulesoft.connectors.internal.utils.ProviderUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayloadUtils.class);
    private static final String[] NO_TEMPERATURE_MODELS = new String[]{"o3-mini", "o3", "o4-mini", "o4", "o1", "o1-mini"};

    public static JSONObject buildPayload(ChatCompletionBase configuration, JSONArray messagesArray, JSONArray toolsArray) {
        JSONObject payload = new JSONObject();
        String inferenceType = configuration.getInferenceType();
        String provider = "";
        if ("VERTEX_AI".equalsIgnoreCase(inferenceType)) {
            provider = ProviderUtils.getProviderByModel(configuration.getModelName());
        }
        LOGGER.debug("provider {} inferenceType {}", (Object)provider, (Object)inferenceType);
        if ("Google".equalsIgnoreCase(provider)) {
            payload.put("contents", (Object)messagesArray);
            JSONObject generationConfig = PayloadUtils.buildVertexAIGenerationConfig(configuration);
            payload.put("generationConfig", (Object)generationConfig);
        } else {
            if ("Anthropic".equalsIgnoreCase(provider) && "VERTEX_AI".equalsIgnoreCase(inferenceType)) {
                payload.put("anthropic_version", (Object)"vertex-2023-10-16");
            }
            if (!("AZURE_OPENAI".equalsIgnoreCase(inferenceType) || "IBM_WATSON".equalsIgnoreCase(inferenceType) || "Anthropic".equalsIgnoreCase(provider))) {
                payload.put("model", (Object)configuration.getModelName());
            }
            if ("IBM_WATSON".equals(configuration.getInferenceType())) {
                payload.put("model_id", (Object)configuration.getModelName());
                payload.put("project_id", (Object)configuration.getibmWatsonProjectID());
            }
            payload.put("messages", (Object)messagesArray);
            if ("GROQ".equalsIgnoreCase(configuration.getInferenceType()) || "OPENAI".equalsIgnoreCase(configuration.getInferenceType())) {
                payload.put("max_completion_tokens", (Object)configuration.getMaxTokens());
            } else {
                payload.put("max_tokens", (Object)configuration.getMaxTokens());
            }
            String modelName = configuration.getModelName();
            if (!Arrays.asList(NO_TEMPERATURE_MODELS).contains(modelName)) {
                payload.put("temperature", (Object)configuration.getTemperature());
                payload.put("top_p", (Object)configuration.getTopP());
            }
            if (toolsArray != null && !toolsArray.isEmpty()) {
                payload.put("tools", (Object)toolsArray);
            }
            if ("OLLAMA".equals(configuration.getInferenceType()) || "AZURE_OPENAI".equals(configuration.getInferenceType()) || "Meta".equalsIgnoreCase(provider)) {
                payload.put("stream", false);
            }
        }
        return payload;
    }

    public static JSONObject buildPayloadImageGeneration(ModerationImageGenerationBase connection, JSONObject requestJson) {
        JSONObject payload = requestJson;
        if ("OPENAI".equalsIgnoreCase(connection.getInferenceType()) || "XAI".equalsIgnoreCase(connection.getInferenceType())) {
            payload.put("model", (Object)connection.getModelName());
        }
        return payload;
    }

    public static JSONObject buildVertexAIPayload(ChatCompletionBase configuration, String prompt, JSONArray safetySettings, JSONObject systemInstruction, JSONArray tools) {
        JSONObject payload = new JSONObject();
        JSONArray partsArray = new JSONArray();
        JSONObject usersPrompt = new JSONObject();
        usersPrompt.put("text", (Object)prompt);
        partsArray.put((Object)usersPrompt);
        JSONObject userContent = new JSONObject();
        userContent.put("role", (Object)"user");
        userContent.put("parts", (Object)partsArray);
        JSONArray contentsArray = new JSONArray();
        contentsArray.put((Object)userContent);
        payload.put("contents", (Object)contentsArray);
        if (systemInstruction != null) {
            payload.put("systemInstruction", (Object)systemInstruction);
        }
        JSONObject generationConfig = PayloadUtils.buildVertexAIGenerationConfig(configuration);
        payload.put("generationConfig", (Object)generationConfig);
        if (safetySettings != null && !safetySettings.isEmpty()) {
            payload.put("safetySettings", (Object)safetySettings);
        }
        if (tools != null && !tools.isEmpty()) {
            payload.put("tools", (Object)tools);
        }
        return payload;
    }

    public static JSONArray parseInputStreamToJsonArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new JSONArray();
        }
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            String jsonString;
            BufferedReader bufferedReader;
            block14: {
                JSONArray jSONArray;
                bufferedReader = new BufferedReader(reader);
                try {
                    String line;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                    jsonString = stringBuilder.toString().trim();
                    if (!jsonString.isEmpty()) break block14;
                    jSONArray = new JSONArray();
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                bufferedReader.close();
                return jSONArray;
            }
            JSONArray jSONArray = new JSONArray(jsonString);
            bufferedReader.close();
            return jSONArray;
        }
    }

    public static JSONArray createMessagesArrayWithSystemPrompt(ChatCompletionBase configuration, String systemContent, String userContent) {
        JSONArray messagesArray = new JSONArray();
        JSONObject systemMessage = new JSONObject();
        systemMessage.put("role", (Object)("ANTHROPIC".equals(configuration.getInferenceType()) ? "assistant" : "system"));
        systemMessage.put("content", (Object)systemContent);
        messagesArray.put((Object)systemMessage);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)userContent);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    public static JSONArray createRequestImageURL(ChatCompletionBase connection, String prompt, String imageUrl) throws IOException {
        String inferenceType = connection.getInferenceType();
        String provider = "";
        if ("VERTEX_AI".equalsIgnoreCase(inferenceType)) {
            provider = ProviderUtils.getProviderByModel(connection.getModelName());
        }
        if (inferenceType.equalsIgnoreCase("ANTHROPIC") || "Anthropic".equalsIgnoreCase(provider)) {
            return PayloadUtils.createAnthropicImageURLRequest(prompt, imageUrl);
        }
        if (inferenceType.equalsIgnoreCase("OLLAMA")) {
            return PayloadUtils.createOllamaImageURLRequest(prompt, imageUrl);
        }
        if ("Google".equalsIgnoreCase(provider)) {
            return PayloadUtils.createVertexAIImageURLRequest(prompt, imageUrl);
        }
        return PayloadUtils.createImageURLRequest(prompt, imageUrl);
    }

    private static JSONArray createImageURLRequest(String prompt, String imageUrl) throws IOException {
        JSONArray messagesArray = new JSONArray();
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        JSONArray contentArray = new JSONArray();
        JSONObject textContent = new JSONObject();
        textContent.put("type", (Object)"text");
        textContent.put("text", (Object)prompt);
        contentArray.put((Object)textContent);
        JSONObject imageContent = new JSONObject();
        imageContent.put("type", (Object)"image_url");
        JSONObject imageMessage = new JSONObject();
        if (PayloadUtils.isBase64String(imageUrl)) {
            imageMessage.put("url", (Object)("data:" + PayloadUtils.getMimeType(imageUrl) + ";base64," + imageUrl));
        } else {
            imageMessage.put("url", (Object)imageUrl);
        }
        imageContent.put("image_url", (Object)imageMessage);
        contentArray.put((Object)imageContent);
        userMessage.put("content", (Object)contentArray);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    private static JSONArray createOllamaImageURLRequest(String prompt, String imageUrl) throws IOException {
        JSONArray messagesArray = new JSONArray();
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)prompt);
        JSONArray imagesArray = new JSONArray();
        if (PayloadUtils.isBase64String(imageUrl)) {
            imagesArray.put((Object)imageUrl);
        } else {
            imagesArray.put((Object)imageUrl);
        }
        userMessage.put("images", (Object)imagesArray);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    private static JSONArray createAnthropicImageURLRequest(String prompt, String imageUrl) throws IOException {
        JSONArray messagesArray = new JSONArray();
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        JSONArray contentArray = new JSONArray();
        JSONObject imageContent = new JSONObject();
        imageContent.put("type", (Object)"image");
        JSONObject imageSource = new JSONObject();
        if (PayloadUtils.isBase64String(imageUrl)) {
            imageSource.put("type", (Object)"base64");
            imageSource.put("media_type", (Object)PayloadUtils.getMimeType(imageUrl));
            imageSource.put("data", (Object)imageUrl);
        } else {
            imageSource.put("type", (Object)"url");
            imageSource.put("url", (Object)imageUrl);
        }
        imageContent.put("source", (Object)imageSource);
        contentArray.put((Object)imageContent);
        JSONObject textContent = new JSONObject();
        textContent.put("type", (Object)"text");
        textContent.put("text", (Object)prompt);
        contentArray.put((Object)textContent);
        userMessage.put("content", (Object)contentArray);
        messagesArray.put((Object)userMessage);
        return messagesArray;
    }

    private static JSONArray createVertexAIImageURLRequest(String prompt, String imageUrl) throws IOException {
        JSONArray parts = new JSONArray();
        if (PayloadUtils.isBase64String(imageUrl)) {
            JSONObject inlineData = new JSONObject();
            inlineData.put("mimeType", (Object)PayloadUtils.getMimeType(imageUrl));
            inlineData.put("data", (Object)imageUrl);
            JSONObject inlineDataWrapper = new JSONObject();
            inlineDataWrapper.put("inlineData", (Object)inlineData);
            parts.put((Object)inlineDataWrapper);
        } else {
            JSONObject fileData = new JSONObject();
            fileData.put("mimeType", (Object)PayloadUtils.getMimeTypeFromUrl(imageUrl));
            fileData.put("fileUri", (Object)imageUrl);
            JSONObject fileDataWrapper = new JSONObject();
            fileDataWrapper.put("fileData", (Object)fileData);
            parts.put((Object)fileDataWrapper);
        }
        JSONObject textPart = new JSONObject();
        textPart.put("text", (Object)prompt);
        parts.put((Object)textPart);
        JSONObject content = new JSONObject();
        content.put("role", (Object)"user");
        content.put("parts", (Object)parts);
        JSONArray contents = new JSONArray();
        contents.put((Object)content);
        return contents;
    }

    public static JSONObject buildChatAnswerPromptPayload(ChatCompletionBase configuration, String prompt) {
        JSONObject payload;
        String provider = "";
        if ("VERTEX_AI".equalsIgnoreCase(configuration.getInferenceType())) {
            provider = ProviderUtils.getProviderByModel(configuration.getModelName());
        }
        if ("Google".equalsIgnoreCase(provider)) {
            JSONArray safetySettings = new JSONArray();
            JSONObject systemInstruction = new JSONObject();
            JSONArray tools = new JSONArray();
            payload = PayloadUtils.buildVertexAIPayload(configuration, prompt, safetySettings, systemInstruction, tools);
        } else if ("Anthropic".equalsIgnoreCase(provider)) {
            JSONObject textObject = new JSONObject().put("type", (Object)"text").put("text", (Object)prompt);
            JSONArray contentArray = new JSONArray().put((Object)textObject);
            JSONObject messageObject = new JSONObject().put("role", (Object)"user").put("content", (Object)contentArray);
            JSONArray messagesArray = new JSONArray().put((Object)messageObject);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
        } else {
            JSONArray messagesArray = new JSONArray();
            JSONObject usersPrompt = new JSONObject();
            usersPrompt.put("role", (Object)"user");
            usersPrompt.put("content", (Object)prompt);
            messagesArray.put((Object)usersPrompt);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
        }
        return payload;
    }

    public static JSONObject buildPromptTemplatePayload(ChatCompletionBase configuration, String template, String instructions, String data) {
        JSONObject payload;
        String provider = "";
        if ("VERTEX_AI".equalsIgnoreCase(configuration.getInferenceType())) {
            provider = ProviderUtils.getProviderByModel(configuration.getModelName());
        }
        if ("Google".equalsIgnoreCase(provider)) {
            JSONObject part = new JSONObject();
            part.put("text", (Object)(template + " - " + instructions));
            JSONArray parts = new JSONArray();
            parts.put((Object)part);
            JSONObject systemInstruction = new JSONObject();
            systemInstruction.put("parts", (Object)parts);
            JSONArray safetySettings = new JSONArray();
            JSONArray tools = new JSONArray();
            payload = PayloadUtils.buildVertexAIPayload(configuration, data, safetySettings, systemInstruction, tools);
        } else if ("Anthropic".equalsIgnoreCase(provider)) {
            JSONObject textObject = new JSONObject().put("type", (Object)"text").put("text", (Object)data);
            JSONArray contentArray = new JSONArray().put((Object)textObject);
            JSONObject messageObject = new JSONObject().put("role", (Object)"user").put("content", (Object)contentArray);
            JSONArray messagesArray = new JSONArray().put((Object)messageObject);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
            payload.put("system", (Object)(template + " - " + instructions));
        } else {
            JSONArray messagesArray = PayloadUtils.createMessagesArrayWithSystemPrompt(configuration, template + " - " + instructions, data);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, null);
        }
        return payload;
    }

    public static JSONObject buildToolsTemplatePayload(TextGenerationConfig inferenceConfig, ChatCompletionBase configuration, String template, String instructions, String data, InputStream tools) throws IOException {
        JSONObject payload;
        String provider = "";
        if ("VERTEX_AI".equalsIgnoreCase(configuration.getInferenceType())) {
            provider = ProviderUtils.getProviderByModel(configuration.getModelName());
        }
        JSONArray toolsArray = PayloadUtils.parseInputStreamToJsonArray(tools);
        LOGGER.debug("provider: {} toolsArray: {}", (Object)provider, (Object)toolsArray.toString());
        if ("Google".equalsIgnoreCase(provider)) {
            JSONObject part = new JSONObject();
            part.put("text", (Object)(template + " - " + instructions));
            JSONArray parts = new JSONArray();
            parts.put((Object)part);
            JSONObject systemInstruction = new JSONObject();
            systemInstruction.put("parts", (Object)parts);
            JSONArray safetySettings = new JSONArray();
            payload = PayloadUtils.buildVertexAIPayload(configuration, data, safetySettings, systemInstruction, toolsArray);
        } else {
            if ("Anthropic".equalsIgnoreCase(provider) || "Meta".equalsIgnoreCase(provider)) {
                throw new IOException(provider + ":" + configuration.getModelName() + " on Vertex AI do not currently support function calling at this time.");
            }
            JSONArray messagesArray = PayloadUtils.createMessagesArrayWithSystemPrompt(configuration, template + " - " + instructions, data);
            payload = PayloadUtils.buildPayload(configuration, messagesArray, toolsArray);
        }
        return payload;
    }

    public static boolean isBase64String(String str) {
        if (str == null || str.length() % 4 != 0 || !str.matches("^[A-Za-z0-9+/]*={0,2}$")) {
            return false;
        }
        try {
            Base64.getDecoder().decode(str);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String getMimeType(String base64String) throws IOException {
        byte[] decodedBytes = Base64.getDecoder().decode(base64String);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
        String mimeType = URLConnection.guessContentTypeFromStream(inputStream);
        return mimeType != null ? mimeType : "image/jpeg";
    }

    public static String getMimeTypeFromUrl(String imageUrl) {
        if (imageUrl == null || imageUrl.trim().isEmpty()) {
            return "image/jpeg";
        }
        if ((imageUrl = imageUrl.toLowerCase().trim()).endsWith(".png")) {
            return "image/png";
        }
        if (imageUrl.endsWith(".jpg") || imageUrl.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    public static JSONObject buildVertexAIGenerationConfig(ChatCompletionBase configuration) {
        JSONObject generationConfig = new JSONObject();
        generationConfig.put("responseModalities", (Object)new String[]{"TEXT"});
        generationConfig.put("temperature", (Object)configuration.getTemperature());
        generationConfig.put("maxOutputTokens", (Object)configuration.getMaxTokens());
        generationConfig.put("topP", (Object)configuration.getTopP());
        return generationConfig;
    }

    public static JSONObject createRequestImageGeneration(String provider, String prompt) throws IOException {
        if (provider.equalsIgnoreCase("OPENAI")) {
            return PayloadUtils.createImageGenerationRequestOpenaI(prompt);
        }
        if (provider.equalsIgnoreCase("HUGGING_FACE")) {
            return PayloadUtils.createImageGenerationRequestHuggingface(prompt);
        }
        if (provider.equalsIgnoreCase("STABILITY_AI")) {
            return PayloadUtils.createImageGenerationRequestStabilityAI(prompt);
        }
        return PayloadUtils.createImageGenerationRequestOpenaI(prompt);
    }

    private static JSONObject createImageGenerationRequestOpenaI(String prompt) throws IOException {
        JSONObject requestPayload = new JSONObject();
        requestPayload.put("prompt", (Object)prompt);
        requestPayload.put("response_format", (Object)"b64_json");
        return requestPayload;
    }

    private static JSONObject createImageGenerationRequestHuggingface(String prompt) throws IOException {
        JSONObject requestPayload = new JSONObject();
        requestPayload.put("inputs", (Object)prompt);
        return requestPayload;
    }

    private static JSONObject createImageGenerationRequestStabilityAI(String prompt) throws IOException {
        JSONObject requestPayload = new JSONObject();
        requestPayload.put("prompt", (Object)prompt);
        return requestPayload;
    }
}

