/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.operations;

import com.mulesoft.connectors.internal.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.internal.config.VisionConfig;
import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.exception.InferenceErrorType;
import com.mulesoft.connectors.internal.utils.ConnectionUtils;
import com.mulesoft.connectors.internal.utils.PayloadUtils;
import com.mulesoft.connectors.internal.utils.ResponseUtils;
import java.io.InputStream;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisionModelOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisionModelOperations.class);
    private static final String ERROR_MSG_FORMAT = "%s result error";

    @MediaType(value="application/json", strict=false)
    @Alias(value="Read-image")
    @DisplayName(value="[Image] Read by (Url or Base64)")
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> readImage(@Config VisionConfig configuration, @Connection ChatCompletionBase connection, @Content String prompt, @Content(primary=true) @DisplayName(value="Image") @Summary(value="An Image URL or a Base64 Image") String imageUrl) throws ModuleException {
        try {
            JSONArray messagesArray = PayloadUtils.createRequestImageURL(connection, prompt, imageUrl);
            URL chatCompUrl = ConnectionUtils.getConnectionURLChatCompletion(connection);
            LOGGER.debug("Read Image with {}", (Object)chatCompUrl);
            JSONObject payload = PayloadUtils.buildPayload(connection, messagesArray, null);
            LOGGER.debug("payload sent to the LLM {}", (Object)payload.toString());
            String response = ConnectionUtils.executeREST(chatCompUrl, connection, payload.toString());
            LOGGER.debug("Read Image result {}", (Object)response);
            return ResponseUtils.processLLMResponse(response, connection);
        }
        catch (Exception e) {
            LOGGER.error("Error in Read Image: {}", (Object)e.getMessage(), (Object)e);
            throw new ModuleException(String.format(ERROR_MSG_FORMAT, "Read Image"), (ErrorTypeDefinition)InferenceErrorType.VISION, (Throwable)e);
        }
    }
}

