/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.connection.types;

import com.mulesoft.connectors.internal.api.proxy.HttpProxyConfig;
import com.mulesoft.connectors.internal.connection.types.TextGeneration;
import com.mulesoft.connectors.internal.models.ModelNameProvider;
import com.mulesoft.connectors.internal.models.ModelTypeProvider;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

@Alias(value="llm")
@DisplayName(value="Text Generation LLM")
public class TextGenerationProvider
implements CachedConnectionProvider<TextGeneration>,
Startable,
Stoppable {
    private HttpClient httpClient;
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Inference Type")
    @OfValues(value=ModelTypeProvider.class)
    private String inferenceType;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="API Key")
    private String apiKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=ModelNameProvider.class)
    @Optional(defaultValue="gpt-3.5-turbo")
    private String modelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="500")
    private Number maxTokens;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="0.9")
    private Number temperature;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="0.9")
    private Number topP;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Timeout (milliseconds)")
    @Optional(defaultValue="#['60000']")
    private int timeout;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Azure AI Foundry] API Version")
    private String azureAIFoundryApiVersion;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Azure AI Foundry] Resource Name")
    private String azureAIFoundryResourceName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Azure OpenAI] Deployment ID")
    private String azureOpenaiDeploymentId;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Azure OpenAI] Resource Name")
    private String azureOpenaiResourceName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="https://<instance>.cloud.databricks.com/")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Databricks] Model URL")
    private String dataBricksModelUrl;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:12434")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Docker Models] Base URL")
    private String dockerModelUrl;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:4891/v1")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[GPT4ALL] Base URL")
    private String gpt4All;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(tab="Additional Properties")
    @Optional
    @DisplayName(value="[IBM Watson] API Version")
    private String ibmWatsonApiVersion;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(tab="Additional Properties")
    @Optional
    @DisplayName(value="[IBM Watson] Project ID")
    private String ibmWatsonProjectID;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:1234/v1")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[LM Studio] Base URL")
    private String lmStudio;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:11434/api")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Ollama] Base URL")
    private String ollamaUrl;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="https://server.endpoint.com")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[OpenAI Compatible] Base URL")
    private String openCompatibleURL;
    @Parameter
    @Optional(defaultValue="Portkey-virtual-key")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Portkey] Virtual Key")
    private String virtualKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://127.0.0.1:9997/v1 or https://inference.top/api/v1")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[Xinference] Base URL")
    private String xnferenceUrl;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="us-central1")
    @Placement(tab="Additional Properties")
    @DisplayName(value="[VertexAI] Location Id")
    private String vertexAILocationId;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(tab="Additional Properties")
    @Optional
    @DisplayName(value="[VertexAI] Project Id")
    private String vertexAIProjectId;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(tab="Additional Properties")
    @Optional
    @DisplayName(value="[VertexAI] Service Account Key")
    private String vertexAIServiceAccountKey;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="MCP Server Urls (SSE over HTTP)")
    private Map<String, String> mcpSseServers;
    @Parameter
    @Placement(order=2, tab="Advanced")
    @Optional
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Placement(tab="Proxy", order=1)
    private HttpProxyConfig proxyConfig;

    public void setInferenceType(String inferenceType) {
        this.inferenceType = inferenceType;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setMaxTokens(Number maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setTemperature(Number temperature) {
        this.temperature = temperature;
    }

    public void setTopP(Number topP) {
        this.topP = topP;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setAzureAIFoundryApiVersion(String azureAIFoundryApiVersion) {
        this.azureAIFoundryApiVersion = azureAIFoundryApiVersion;
    }

    public void setAzureAIFoundryResourceName(String azureAIFoundryResourceName) {
        this.azureAIFoundryResourceName = azureAIFoundryResourceName;
    }

    public void setAzureOpenaiDeploymentId(String azureOpenaiDeploymentId) {
        this.azureOpenaiDeploymentId = azureOpenaiDeploymentId;
    }

    public void setAzureOpenaiResourceName(String azureOpenaiResourceName) {
        this.azureOpenaiResourceName = azureOpenaiResourceName;
    }

    public void dataBricksModelUrl(String dataBricksModelUrl) {
        this.dataBricksModelUrl = dataBricksModelUrl;
    }

    public void setDockerModelUrl(String dockerModelUrl) {
        this.dockerModelUrl = dockerModelUrl;
    }

    public void setGpt4All(String gpt4All) {
        this.gpt4All = gpt4All;
    }

    public void setIBMWatsonApiVersion(String ibmWatsonApiVersion) {
        this.ibmWatsonApiVersion = ibmWatsonApiVersion;
    }

    public void setibmWatsonProjectID(String ibmWatsonProjectID) {
        this.ibmWatsonProjectID = ibmWatsonProjectID;
    }

    public void setLmStudio(String lmStudio) {
        this.lmStudio = lmStudio;
    }

    public void setOllamaUrl(String ollamaUrl) {
        this.ollamaUrl = ollamaUrl;
    }

    public void setOpenAICompatibleURL(String openCompatibleURL) {
        this.openCompatibleURL = openCompatibleURL;
    }

    public void setVirtualKey(String virtualKey) {
        this.virtualKey = virtualKey;
    }

    public void setXinferenceUrl(String xnferenceUrl) {
        this.xnferenceUrl = xnferenceUrl;
    }

    public void setVertexAILocationId(String vertexAILocationId) {
        this.vertexAILocationId = vertexAILocationId;
    }

    public void setVertexAIProjectId(String vertexAIProjectId) {
        this.vertexAIProjectId = vertexAIProjectId;
    }

    public void setVertexAIServiceAccountKey(String vertexAIServiceAccountKey) {
        this.vertexAIServiceAccountKey = vertexAIServiceAccountKey;
    }

    public void setMcpSseServers(Map<String, String> mcpSseServers) {
        this.mcpSseServers = mcpSseServers;
    }

    public TextGeneration connect() throws ConnectionException {
        return new TextGeneration(this.httpClient, this.timeout, this.inferenceType, this.apiKey, this.modelName, this.maxTokens, this.temperature, this.topP, this.azureAIFoundryApiVersion, this.azureAIFoundryResourceName, this.azureOpenaiDeploymentId, this.azureOpenaiResourceName, this.dataBricksModelUrl, this.dockerModelUrl, this.gpt4All, this.ibmWatsonApiVersion, this.ibmWatsonProjectID, this.lmStudio, this.ollamaUrl, this.openCompatibleURL, this.virtualKey, this.xnferenceUrl, this.vertexAIProjectId, this.vertexAILocationId, this.vertexAIServiceAccountKey, this.mcpSseServers);
    }

    public void disconnect(TextGeneration textGeneration) {
    }

    public ConnectionValidationResult validate(TextGeneration textGeneration) {
        try {
            textGeneration.validate();
            return ConnectionValidationResult.success();
        }
        catch (ConnectionException e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void start() throws MuleException {
        HttpClientConfiguration config = this.createClientConfiguration();
        this.httpClient = this.httpService.getClientFactory().create(config);
        this.httpClient.start();
    }

    private HttpClientConfiguration createClientConfiguration() {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder().setName(this.configName);
        if (null != this.tlsContext) {
            builder.setTlsContextFactory(this.tlsContext);
        } else {
            builder.setTlsContextFactory(TlsContextFactory.builder().buildDefault());
        }
        if (this.proxyConfig != null) {
            builder.setProxyConfig((ProxyConfig)this.proxyConfig);
        }
        return builder.build();
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }
}

