/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.internal.utils;

import com.mulesoft.connectors.internal.connection.ChatCompletionBase;
import com.mulesoft.connectors.internal.connection.ModerationImageGenerationBase;
import com.mulesoft.connectors.internal.utils.PayloadUtils;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.http.api.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderUtils.class);
    static JSONArray mcpToolsArray = null;
    static JSONArray mcpToolsArrayByServer = null;

    public static boolean isllamaAPI(ChatCompletionBase configuration) {
        return "LLM_API".equals(configuration.getInferenceType());
    }

    public static boolean isOllama(ChatCompletionBase configuration) {
        return "OLLAMA".equals(configuration.getInferenceType());
    }

    public static boolean isHuggingFace(ChatCompletionBase configuration) {
        return "HUGGING_FACE".equals(configuration.getInferenceType());
    }

    public static boolean isAnthropic(ChatCompletionBase configuration) {
        return "ANTHROPIC".equals(configuration.getInferenceType());
    }

    public static boolean isNvidia(ChatCompletionBase configuration) {
        return "NVIDIA".equals(configuration.getInferenceType());
    }

    public static boolean isCohere(ChatCompletionBase configuration) {
        return "COHERE".equals(configuration.getInferenceType());
    }

    public static boolean isVertexAIExpress(ChatCompletionBase configuration) {
        return "VERTEX_AI_EXPRESS".equals(configuration.getInferenceType());
    }

    public static boolean isVertexAI(ChatCompletionBase configuration) {
        return "VERTEX_AI".equals(configuration.getInferenceType());
    }

    public static String getProviderByModel(String modelName) {
        LOGGER.debug("model name {}", (Object)modelName);
        if (modelName == null || modelName.isEmpty()) {
            return "Unknown";
        }
        String upperName = modelName.toUpperCase();
        if (upperName.startsWith("GEMINI")) {
            return "Google";
        }
        if (upperName.startsWith("CLAUDE")) {
            return "Anthropic";
        }
        if (upperName.startsWith("META")) {
            return "Meta";
        }
        return "Unknown";
    }

    public static boolean isOpenAI(ChatCompletionBase configuration) {
        return "OPENAI".equals(configuration.getInferenceType());
    }

    public static boolean isStabilityAI(ChatCompletionBase configuration) {
        return "STABILITY_AI".equals(configuration.getInferenceType());
    }

    public static boolean isXAI(ChatCompletionBase configuration) {
        return "XAI".equals(configuration.getInferenceType());
    }

    @NotNull
    public static ChatCompletionBase convertToBaseConnection(ModerationImageGenerationBase imageGenerationBase) {
        BaseConnectionImpl baseConnection = new BaseConnectionImpl();
        baseConnection.setHttpClient(imageGenerationBase.getHttpClient());
        baseConnection.setInferenceType(imageGenerationBase.getInferenceType());
        baseConnection.setApiKey(imageGenerationBase.getApiKey());
        baseConnection.setModelName(imageGenerationBase.getModelName());
        baseConnection.setTimeout(imageGenerationBase.getTimeout());
        return baseConnection;
    }

    private static McpSyncClient establishClientMCP(String mcpServerUrl) {
        HttpClientSseClientTransport transport = HttpClientSseClientTransport.builder((String)mcpServerUrl).build();
        McpSyncClient client = McpClient.sync((McpClientTransport)transport).requestTimeout(Duration.ofSeconds(60L)).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build()).build();
        client.initialize();
        return client;
    }

    public static JSONArray getMcpToolsFromMultiple(ChatCompletionBase connection) {
        mcpToolsArrayByServer = new JSONArray();
        JSONArray mcpTools = new JSONArray();
        Map<String, String> mcpServers = connection.getMcpSseServers();
        String httpPattern = "^https?://.*";
        for (Map.Entry<String, String> entry : mcpServers.entrySet()) {
            JSONArray tools;
            String url = entry.getValue();
            String key = entry.getKey();
            if (url == null || !url.matches(httpPattern) || (tools = ProviderUtils.getMcpTools(url)) == null) continue;
            for (int i = 0; i < tools.length(); ++i) {
                mcpTools.put(tools.get(i));
            }
            JSONObject mcpServerInfo = new JSONObject();
            mcpServerInfo.put("serverUrl", (Object)url);
            mcpServerInfo.put("serverName", (Object)key);
            mcpServerInfo.put("serverTools", (Object)tools);
            boolean exists = false;
            for (int i = 0; i < mcpToolsArrayByServer.length(); ++i) {
                JSONObject existing = mcpToolsArrayByServer.getJSONObject(i);
                if (!existing.getString("serverUrl").equals(url)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            mcpToolsArrayByServer.put((Object)mcpServerInfo);
        }
        return mcpTools;
    }

    public static JSONArray getMcpTools(String mcpServerUrl) {
        McpSyncClient client = ProviderUtils.establishClientMCP(mcpServerUrl);
        McpSchema.ListToolsResult tools = client.listTools();
        mcpToolsArray = new JSONArray();
        for (McpSchema.Tool tool : tools.tools()) {
            Map.Entry prop2;
            JSONObject functionObj = new JSONObject();
            functionObj.put("name", (Object)tool.name());
            functionObj.put("description", (Object)tool.description());
            JSONObject parametersObj = new JSONObject();
            parametersObj.put("type", (Object)"object");
            JSONObject propertiesObj = new JSONObject();
            if (tool.inputSchema().properties() != null) {
                for (Map.Entry prop2 : tool.inputSchema().properties().entrySet()) {
                    if (!(prop2.getValue() instanceof Map)) continue;
                    Map propDetails = (Map)prop2.getValue();
                    JSONObject propObj = new JSONObject();
                    for (Map.Entry detail : propDetails.entrySet()) {
                        propObj.put((String)detail.getKey(), detail.getValue());
                    }
                    propertiesObj.put((String)prop2.getKey(), (Object)propObj);
                }
            }
            parametersObj.put("properties", (Object)propertiesObj);
            JSONArray requiredArray = new JSONArray();
            prop2 = tool.inputSchema().properties().keySet().iterator();
            while (prop2.hasNext()) {
                String key = (String)prop2.next();
                requiredArray.put((Object)key);
            }
            parametersObj.put("required", (Object)requiredArray);
            parametersObj.put("additionalProperties", tool.inputSchema().additionalProperties() != null ? tool.inputSchema().additionalProperties() : false);
            functionObj.put("parameters", (Object)parametersObj);
            JSONObject toolObj = new JSONObject();
            toolObj.put("type", (Object)"function");
            toolObj.put("function", (Object)functionObj);
            mcpToolsArray.put((Object)toolObj);
        }
        client.close();
        return mcpToolsArray;
    }

    public static JSONArray executeTools(String apiResponseJson) throws Exception {
        LOGGER.debug("executeTools - Response from the tools server: {}", (Object)apiResponseJson);
        JSONArray resultsArray = new JSONArray();
        JSONObject rootObject = new JSONObject(apiResponseJson);
        JSONArray toolsArray = rootObject.getJSONArray("tools");
        if (toolsArray.length() == 0) {
            return resultsArray;
        }
        for (int i = 0; i < toolsArray.length(); ++i) {
            JSONObject toolObject = toolsArray.getJSONObject(i);
            JSONObject functionObject = toolObject.getJSONObject("function");
            String functionName = functionObject.getString("name");
            JSONObject argumentsObject = functionObject.getJSONObject("arguments");
            String serverUrl = ProviderUtils.findServerUrlForTool(mcpToolsArrayByServer, functionName);
            String serverName = ProviderUtils.findServerNameForTool(mcpToolsArrayByServer, functionName);
            McpSyncClient client = ProviderUtils.establishClientMCP(serverUrl);
            HashMap<String, String> arguments = new HashMap<String, String>();
            for (String key : argumentsObject.keySet()) {
                arguments.put(key, argumentsObject.getString(key));
            }
            McpSchema.CallToolRequest request = new McpSchema.CallToolRequest(functionName, arguments);
            McpSchema.CallToolResult result = client.callTool(request);
            JSONObject contentObj = new JSONObject();
            for (McpSchema.Content content : result.content()) {
                if (!(content instanceof McpSchema.TextContent)) continue;
                McpSchema.TextContent textContent = (McpSchema.TextContent)content;
                LOGGER.info("Debugging the exception. TextContent is {} ", (Object)textContent.text());
                if (PayloadUtils.isValidJson(textContent.text())) {
                    contentObj.put("result", (Object)new JSONObject(textContent.text()));
                    continue;
                }
                contentObj.put("result", (Object)textContent.text());
            }
            JSONObject resultObject = new JSONObject();
            resultObject.put("tool", (Object)functionName);
            try {
                resultObject.put("result", (Object)contentObj.getJSONObject("result"));
            }
            catch (Exception e) {
                resultObject.put("result", (Object)contentObj.getString("result"));
            }
            resultObject.put("serverUrl", (Object)serverUrl);
            resultObject.put("serverName", (Object)serverName);
            resultObject.put("timestamp", (Object)Instant.now());
            resultsArray.put((Object)resultObject);
            client.close();
        }
        return resultsArray;
    }

    private static String findServerUrlForTool(JSONArray servers, String toolName) {
        for (int i = 0; i < servers.length(); ++i) {
            JSONObject server = servers.getJSONObject(i);
            JSONArray serverTools = server.getJSONArray("serverTools");
            for (int j = 0; j < serverTools.length(); ++j) {
                JSONObject serverTool = serverTools.getJSONObject(j);
                String serverToolName = serverTool.getJSONObject("function").getString("name");
                if (!toolName.equals(serverToolName)) continue;
                return server.getString("serverUrl");
            }
        }
        return null;
    }

    private static String findServerNameForTool(JSONArray servers, String toolName) {
        for (int i = 0; i < servers.length(); ++i) {
            JSONObject server = servers.getJSONObject(i);
            JSONArray serverTools = server.getJSONArray("serverTools");
            for (int j = 0; j < serverTools.length(); ++j) {
                JSONObject serverTool = serverTools.getJSONObject(j);
                String serverToolName = serverTool.getJSONObject("function").getString("name");
                if (!toolName.equals(serverToolName)) continue;
                return server.getString("serverName");
            }
        }
        return null;
    }

    private static class BaseConnectionImpl
    implements ChatCompletionBase {
        private HttpClient httpClient;
        private String inferenceType;
        private String apiKey;
        private String modelName;
        private int timeout;
        private Number maxTokens;
        private Number temperature;
        private Number topP;
        private String azureAIFoundryApiVersion;
        private String azureAIFoundryResourceName;
        private String azureOpenaiDeploymentId;
        private String azureOpenaiResourceName;
        private String dataBricksModelUrl;
        private String dockerModelUrl;
        private String gpt4All;
        private String ibmWatsonApiVersion;
        private String ibmWatsonProjectID;
        private String lmStudio;
        private String ollamaUrl;
        private String openCompatibleURL;
        private String virtualKey;
        private String xnferenceUrl;
        private String vertexAIProjectId;
        private String vertexAILocationId;
        private String vertexAIServiceAccountKey;
        private Map<String, String> mcpSseServers;

        private BaseConnectionImpl() {
        }

        @Override
        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        public void setHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        @Override
        public String getInferenceType() {
            return this.inferenceType;
        }

        public void setInferenceType(String inferenceType) {
            this.inferenceType = inferenceType;
        }

        @Override
        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public Number getMaxTokens() {
            return this.maxTokens;
        }

        public void setMaxTokens(Number maxTokens) {
            this.maxTokens = maxTokens;
        }

        @Override
        public Number getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Number temperature) {
            this.temperature = temperature;
        }

        @Override
        public Number getTopP() {
            return this.topP;
        }

        public void setTopP(Number topP) {
            this.topP = topP;
        }

        @Override
        public String getAzureAIFoundryApiVersion() {
            return this.azureAIFoundryApiVersion;
        }

        public void setAzureAIFoundryApiVersion(String azureAIFoundryApiVersion) {
            this.azureAIFoundryApiVersion = azureAIFoundryApiVersion;
        }

        @Override
        public String getAzureAIFoundryResourceName() {
            return this.azureAIFoundryResourceName;
        }

        public void setAzureAIFoundryResourceName(String azureAIFoundryResourceName) {
            this.azureAIFoundryResourceName = azureAIFoundryResourceName;
        }

        @Override
        public String getAzureOpenaiDeploymentId() {
            return this.azureOpenaiDeploymentId;
        }

        public void setAzureOpenaiDeploymentId(String azureOpenaiDeploymentId) {
            this.azureOpenaiDeploymentId = azureOpenaiDeploymentId;
        }

        @Override
        public String getAzureOpenaiResourceName() {
            return this.azureOpenaiResourceName;
        }

        public void setAzureOpenaiResourceName(String azureOpenaiResourceName) {
            this.azureOpenaiResourceName = azureOpenaiResourceName;
        }

        @Override
        public String getDataBricksModelUrl() {
            return this.dataBricksModelUrl;
        }

        public void dataBricksModelUrl(String dataBricksModelUrl) {
            this.dataBricksModelUrl = dataBricksModelUrl;
        }

        @Override
        public String getDockerModelUrl() {
            return this.dockerModelUrl;
        }

        public void setDockerModelUrl(String dockerModelUrl) {
            this.dockerModelUrl = dockerModelUrl;
        }

        @Override
        public String getGpt4All() {
            return this.gpt4All;
        }

        public void setGpt4All(String gpt4All) {
            this.gpt4All = gpt4All;
        }

        @Override
        public String getIBMWatsonApiVersion() {
            return this.ibmWatsonApiVersion;
        }

        public void setIBMWatsonApiVersion(String ibmWatsonApiVersion) {
            this.ibmWatsonApiVersion = ibmWatsonApiVersion;
        }

        @Override
        public String getibmWatsonProjectID() {
            return this.ibmWatsonProjectID;
        }

        public void setibmWatsonProjectID(String ibmWatsonProjectID) {
            this.ibmWatsonProjectID = ibmWatsonProjectID;
        }

        @Override
        public String getLmStudio() {
            return this.lmStudio;
        }

        public void setLmStudio(String lmStudio) {
            this.lmStudio = lmStudio;
        }

        @Override
        public String getOllamaUrl() {
            return this.ollamaUrl;
        }

        public void setOllamaUrl(String ollamaUrl) {
            this.ollamaUrl = ollamaUrl;
        }

        @Override
        public String getOpenAICompatibleURL() {
            return this.openCompatibleURL;
        }

        public void setOpenAICompatibleURL(String openCompatibleURL) {
            this.openCompatibleURL = openCompatibleURL;
        }

        @Override
        public String getVirtualKey() {
            return this.virtualKey;
        }

        public void setVirtualKey(String virtualKey) {
            this.virtualKey = virtualKey;
        }

        @Override
        public String getxinferenceUrl() {
            return this.xnferenceUrl;
        }

        public void setXinferenceUrl(String xnferenceUrl) {
            this.xnferenceUrl = xnferenceUrl;
        }

        @Override
        public String getVertexAIProjectId() {
            return this.vertexAIProjectId;
        }

        public void setVertexAIProjectId(String vertexAIProjectId) {
            this.vertexAIProjectId = vertexAIProjectId;
        }

        @Override
        public String getVertexAILocationId() {
            return this.vertexAILocationId;
        }

        public void setVertexAILocationId(String vertexAILocationId) {
            this.vertexAILocationId = vertexAILocationId;
        }

        @Override
        public String getVertexAIServiceAccountKey() {
            return this.vertexAIServiceAccountKey;
        }

        public void setVertexAIServiceAccountKey(String vertexAIServiceAccountKey) {
            this.vertexAIServiceAccountKey = vertexAIServiceAccountKey;
        }

        @Override
        public Map<String, String> getMcpSseServers() {
            return this.mcpSseServers;
        }

        public void setMcpSseServers(Map<String, String> mcpSseServerUrl_5) {
            this.mcpSseServers = this.mcpSseServers;
        }
    }
}

