/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.azure;

import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.azure.AzureAIFoundryTextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.azure.providers.AzureAIFoundryTextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="azure-ai-foundry")
@DisplayName(value="Azure AI Foundry")
public class AzureAIFoundryTextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(AzureAIFoundryTextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=AzureAIFoundryTextGenerationModelNameProvider.class)
    private String azureModelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="[Azure AI Foundry] Resource Name")
    @Placement(order=2)
    private String azureAIFoundryResourceName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="[Azure AI Foundry] API Version")
    @Placement(order=3)
    private String azureAIFoundryApiVersion;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters textGenerationConnectionParameters;

    public AzureAIFoundryTextGenerationConnection connect() throws ConnectionException {
        logger.debug("AzureAIFoundryTextGenerationConnection connect ...");
        return new AzureAIFoundryTextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.azureModelName, this.textGenerationConnectionParameters.getApiKey(), this.textGenerationConnectionParameters.getMaxTokens(), this.textGenerationConnectionParameters.getTemperature(), this.textGenerationConnectionParameters.getTopP(), this.textGenerationConnectionParameters.getTimeout()), this.azureAIFoundryResourceName, this.azureAIFoundryApiVersion);
    }
}

