/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.azure;

import com.mulesoft.connectors.inference.internal.connection.parameters.VisionConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.VisionModelConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.azure.AzureAIFoundryVisionConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.azure.providers.AzureAIFoundryVisionModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="azure-ai-foundry-vision")
@DisplayName(value="Azure AI Foundry")
public class AzureAIFoundryVisionConnectionProvider
extends VisionModelConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(AzureAIFoundryVisionConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=AzureAIFoundryVisionModelNameProvider.class)
    private String azureAIFoundryModelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="[Azure AI Foundry] Resource Name")
    @Placement(order=2)
    private String azureAIFoundryResourceName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="[Azure AI Foundry] API Version")
    @Placement(order=3)
    private String azureAIFoundryApiVersion;
    @ParameterGroup(name="Connection")
    private VisionConnectionParameters visionConnectionParameters;

    public AzureAIFoundryVisionConnection connect() throws ConnectionException {
        logger.debug("AzureAIFoundryVisionConnection connect ...");
        return new AzureAIFoundryVisionConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.azureAIFoundryModelName, this.visionConnectionParameters.getApiKey(), this.visionConnectionParameters.getMaxTokens(), this.visionConnectionParameters.getTemperature(), this.visionConnectionParameters.getTopP(), this.visionConnectionParameters.getTimeout()), this.azureAIFoundryResourceName, this.azureAIFoundryApiVersion);
    }
}

