/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.ollama;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.helpers.payload.OllamaRequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.OllamaHttpResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.OllamaResponseMapper;
import org.mule.runtime.http.api.client.HttpClient;

public class OllamaVisionConnection
extends VisionModelConnection {
    private static final String URI_CHAT_COMPLETIONS = "/chat";
    private OllamaRequestPayloadHelper requestPayloadHelper;
    private OllamaHttpResponseHelper httpResponseHelper;
    private OllamaResponseMapper responseMapper;

    public OllamaVisionConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO, String ollamaUrl) {
        super(httpClient, objectMapper, parametersDTO, OllamaVisionConnection.fetchApiURL(ollamaUrl));
    }

    @Override
    public OllamaRequestPayloadHelper getRequestPayloadHelper() {
        if (this.requestPayloadHelper == null) {
            this.requestPayloadHelper = new OllamaRequestPayloadHelper(this.getObjectMapper());
        }
        return this.requestPayloadHelper;
    }

    @Override
    public OllamaHttpResponseHelper getResponseHelper() {
        if (this.httpResponseHelper == null) {
            this.httpResponseHelper = new OllamaHttpResponseHelper(this.getObjectMapper());
        }
        return this.httpResponseHelper;
    }

    @Override
    public OllamaResponseMapper getResponseMapper() {
        if (this.responseMapper == null) {
            this.responseMapper = new OllamaResponseMapper(this.getObjectMapper());
        }
        return this.responseMapper;
    }

    private static String fetchApiURL(String ollamaUrl) {
        return ollamaUrl + URI_CHAT_COMPLETIONS;
    }
}

