/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.helpers.payload.OpenAIRequestPayloadHelper;
import org.mule.runtime.http.api.client.HttpClient;

public class OpenAITextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "/chat/completions";
    public static final String OPENAI_URL = "https://api.openai.com/v1";
    private OpenAIRequestPayloadHelper requestPayloadHelper;

    public OpenAITextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO) {
        super(httpClient, objectMapper, parametersDTO, OpenAITextGenerationConnection.fetchApiURL());
    }

    @Override
    public OpenAIRequestPayloadHelper getRequestPayloadHelper() {
        if (this.requestPayloadHelper == null) {
            this.requestPayloadHelper = new OpenAIRequestPayloadHelper(this.getObjectMapper());
        }
        return this.requestPayloadHelper;
    }

    private static String fetchApiURL() {
        return "https://api.openai.com/v1/chat/completions";
    }
}

