/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.portkey;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;

public class PortkeyTextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "/chat/completions";
    public static final String PORTKEY_URL = "https://api.portkey.ai/v1";
    private final String virtualKey;

    public PortkeyTextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO, String virtualKey) {
        super(httpClient, objectMapper, parametersDTO, PortkeyTextGenerationConnection.fetchApiURL());
        this.virtualKey = virtualKey;
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        return Map.of("x-portkey-api-key", this.getApiKey(), "x-portkey-virtual-key", this.virtualKey);
    }

    private static String fetchApiURL() {
        return "https://api.portkey.ai/v1/chat/completions";
    }
}

