/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.vertexai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.helpers.payload.VertexAIRequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.VertexAIHttpResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.VertexAIResponseMapper;
import java.util.Collections;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;

public class VertexAIExpressTextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "generateContent";
    public static final String VERTEX_AI_EXPRESS_URL = "https://aiplatform.googleapis.com/v1/publishers/google/models/{model_id}:";
    private VertexAIRequestPayloadHelper requestPayloadHelper;
    private VertexAIResponseMapper responseMapper;
    private VertexAIHttpResponseHelper httpResponseHelper;

    public VertexAIExpressTextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO) {
        super(httpClient, objectMapper, parametersDTO, VertexAIExpressTextGenerationConnection.fetchApiURL(parametersDTO.modelName()));
    }

    @Override
    public VertexAIRequestPayloadHelper getRequestPayloadHelper() {
        if (this.requestPayloadHelper == null) {
            this.requestPayloadHelper = new VertexAIRequestPayloadHelper(this.getObjectMapper());
        }
        return this.requestPayloadHelper;
    }

    @Override
    public VertexAIResponseMapper getResponseMapper() {
        if (this.responseMapper == null) {
            this.responseMapper = new VertexAIResponseMapper(this.getObjectMapper());
        }
        return this.responseMapper;
    }

    @Override
    public VertexAIHttpResponseHelper getResponseHelper() {
        if (this.httpResponseHelper == null) {
            this.httpResponseHelper = new VertexAIHttpResponseHelper(this.getObjectMapper());
        }
        return this.httpResponseHelper;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return Map.of("key", this.getApiKey());
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        return Collections.emptyMap();
    }

    private static String fetchApiURL(String modelName) {
        String vertexAIExpressUrlStr = "https://aiplatform.googleapis.com/v1/publishers/google/models/{model_id}:generateContent";
        vertexAIExpressUrlStr = vertexAIExpressUrlStr.replace("{model_id}", modelName);
        return vertexAIExpressUrlStr;
    }
}

