/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.BaseConnection;
import com.mulesoft.connectors.inference.internal.connection.types.ImageGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.imagegeneration.ImageGenerationRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.dto.imagegeneration.StabilityAIImageRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.helpers.request.HttpRequestHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StabilityAIHttpRequestHelper
extends HttpRequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(StabilityAIHttpRequestHelper.class);

    public StabilityAIHttpRequestHelper(HttpClient httpClient, ObjectMapper objectMapper) {
        super(httpClient, objectMapper);
    }

    @Override
    public HttpResponse executeImageGenerationRestRequest(ImageGenerationConnection connection, String resourceUrl, ImageGenerationRequestPayloadDTO payload) throws IOException, TimeoutException {
        StabilityAIImageRequestPayloadRecord payloadRecord = (StabilityAIImageRequestPayloadRecord)payload;
        return this.executeRestRequestStabilityAi(connection, resourceUrl, payloadRecord.prompt());
    }

    private HttpResponse executeRestRequestStabilityAi(BaseConnection connection, String resourceUrl, String payload) throws IOException, TimeoutException {
        byte[] promptBytes = payload.getBytes(StandardCharsets.UTF_8);
        MultipartHttpEntity entity = new MultipartHttpEntity(List.of(new HttpPart("prompt", promptBytes, "text/plain", promptBytes.length)));
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.createDefaultRequestBuilderStabilityAi(resourceUrl).addHeader("Content-Type", "multipart/form-data")).headers(new MultiMap(connection.getAdditionalHeaders()))).queryParams(new MultiMap(connection.getQueryParams())).entity((HttpEntity)entity);
        logger.debug("Sending request to URL: {}", (Object)resourceUrl);
        logger.trace("Request headers: {}", (Object)requestBuilder.getHeaders());
        logger.trace("Request queryParams: {}", (Object)requestBuilder.getQueryParams());
        HttpRequestOptions options = this.getRequestOptionsStabilityAi(connection.getTimeout());
        return this.httpClient.send(requestBuilder.build(), options);
    }

    private HttpRequestBuilder createDefaultRequestBuilderStabilityAi(String url) {
        return (HttpRequestBuilder)HttpRequest.builder().uri(url).method("POST").headers(this.getDefaultHeadersStabilityAi());
    }

    private MultiMap<String, String> getDefaultHeadersStabilityAi() {
        return new MultiMap(Map.of("Accept", "application/json"));
    }

    private HttpRequestOptions getRequestOptionsStabilityAi(int timeout) {
        return HttpRequestOptions.builder().responseTimeout(timeout).followsRedirect(true).build();
    }
}

