/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.ollama.OllamaChatCompletionResponse;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.helpers.response.HttpResponseHelper;
import java.io.IOException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OllamaHttpResponseHelper
extends HttpResponseHelper {
    private static final Logger logger = LoggerFactory.getLogger(OllamaHttpResponseHelper.class);

    public OllamaHttpResponseHelper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public OllamaChatCompletionResponse processChatResponse(HttpResponse response, InferenceErrorType errorType) throws IOException {
        logger.debug("Processing Ollama chat response. Response Code:{}", (Object)response.getStatusCode());
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            return (OllamaChatCompletionResponse)this.objectMapper.readValue(response.getEntity().getBytes(), OllamaChatCompletionResponse.class);
        }
        throw this.handleErrorResponse(response, statusCode, errorType);
    }
}

