/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.metadata.AdditionalAttributes;
import com.mulesoft.connectors.inference.api.response.TextGenerationResponse;
import com.mulesoft.connectors.inference.api.response.ToolCall;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.ChatCompletionResponse;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.Choice;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TextResponseDTO;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TokenUsage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseMapper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResponseMapper.class);
    protected final ObjectMapper objectMapper;

    public DefaultResponseMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public TextGenerationResponse mapChatResponse(TextResponseDTO responseDTO) {
        ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)responseDTO;
        Choice chatRespFirstChoice = chatCompletionResponse.choices().get(0);
        return new TextGenerationResponse(chatRespFirstChoice.message().content(), chatRespFirstChoice.message().toolCalls());
    }

    public com.mulesoft.connectors.inference.api.metadata.TokenUsage mapTokenUsageFromResponse(TextResponseDTO responseDTO) {
        ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)responseDTO;
        TokenUsage chatRespUsage = chatCompletionResponse.usage();
        return new com.mulesoft.connectors.inference.api.metadata.TokenUsage(chatRespUsage.promptTokens(), chatRespUsage.completionTokens(), chatRespUsage.totalTokens());
    }

    public AdditionalAttributes mapAdditionalAttributes(TextResponseDTO responseDTO, String modelName) {
        logger.debug("Map Additional attributes for model:{}", (Object)modelName);
        ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)responseDTO;
        Choice chatRespFirstChoice = chatCompletionResponse.choices().get(0);
        return new AdditionalAttributes(chatCompletionResponse.id(), chatCompletionResponse.model(), chatRespFirstChoice.finishReason());
    }

    public List<ToolCall> mapToolCalls(TextResponseDTO responseDTO) {
        ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)responseDTO;
        Choice chatRespFirstChoice = chatCompletionResponse.choices().get(0);
        return chatRespFirstChoice.message().toolCalls();
    }
}

