/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.metadata.AdditionalAttributes;
import com.mulesoft.connectors.inference.api.metadata.TokenUsage;
import com.mulesoft.connectors.inference.api.response.Function;
import com.mulesoft.connectors.inference.api.response.TextGenerationResponse;
import com.mulesoft.connectors.inference.api.response.ToolCall;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TextResponseDTO;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.ollama.OllamaChatCompletionResponse;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.DefaultResponseMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OllamaResponseMapper
extends DefaultResponseMapper {
    private static final Logger logger = LoggerFactory.getLogger(OllamaResponseMapper.class);

    public OllamaResponseMapper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public TextGenerationResponse mapChatResponse(TextResponseDTO responseDTO) {
        OllamaChatCompletionResponse chatCompletionResponse = (OllamaChatCompletionResponse)responseDTO;
        return new TextGenerationResponse(chatCompletionResponse.message().content(), this.mapToolCalls(responseDTO));
    }

    @Override
    public TokenUsage mapTokenUsageFromResponse(TextResponseDTO responseDTO) {
        OllamaChatCompletionResponse chatCompletionResponse = (OllamaChatCompletionResponse)responseDTO;
        return new TokenUsage(chatCompletionResponse.promptEvalCount(), chatCompletionResponse.evalCount(), chatCompletionResponse.promptEvalCount() + chatCompletionResponse.evalCount());
    }

    @Override
    public AdditionalAttributes mapAdditionalAttributes(TextResponseDTO responseDTO, String modelName) {
        OllamaChatCompletionResponse chatCompletionResponse = (OllamaChatCompletionResponse)responseDTO;
        return new AdditionalAttributes(null, chatCompletionResponse.model(), chatCompletionResponse.doneReason());
    }

    @Override
    public List<ToolCall> mapToolCalls(TextResponseDTO responseDTO) {
        OllamaChatCompletionResponse chatCompletionResponse = (OllamaChatCompletionResponse)responseDTO;
        return Optional.ofNullable(chatCompletionResponse.message().toolCalls()).map(toolCalls -> toolCalls.stream().map(toolCall -> new ToolCall(null, "function", new Function(toolCall.function().name(), this.convertToJsonString(toolCall.function().arguments())))).toList()).orElse(Collections.emptyList());
    }

    private String convertToJsonString(Map<String, Object> input) {
        try {
            return this.objectMapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            logger.error("Error converting input to JSON string for tool call. Value for input field: {}", input, (Object)e);
            return null;
        }
    }
}

