/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.service;

import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.service.ImageGenerationService;
import com.mulesoft.connectors.inference.internal.service.ModerationService;
import com.mulesoft.connectors.inference.internal.service.TextGenerationService;
import com.mulesoft.connectors.inference.internal.service.VisionModelService;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public interface BaseService {
    default public TextGenerationService getTextGenerationServiceInstance() {
        BaseService baseService = this;
        if (baseService instanceof TextGenerationService) {
            TextGenerationService textGenerationService = (TextGenerationService)baseService;
            return textGenerationService;
        }
        throw new ModuleException("Text Generation Service not found", (ErrorTypeDefinition)InferenceErrorType.CHAT_OPERATION_FAILURE);
    }

    default public ImageGenerationService getImageGenerationServiceInstance() {
        BaseService baseService = this;
        if (baseService instanceof ImageGenerationService) {
            ImageGenerationService imageGenerationServiceInstance = (ImageGenerationService)baseService;
            return imageGenerationServiceInstance;
        }
        throw new ModuleException("Image Generation Service not found", (ErrorTypeDefinition)InferenceErrorType.IMAGE_GENERATION_FAILURE);
    }

    default public VisionModelService getVisionModelServiceInstance() {
        BaseService baseService = this;
        if (baseService instanceof VisionModelService) {
            VisionModelService visionModelServiceInstance = (VisionModelService)baseService;
            return visionModelServiceInstance;
        }
        throw new ModuleException("Vision Model Service not found", (ErrorTypeDefinition)InferenceErrorType.READ_IMAGE_OPERATION_FAILURE);
    }

    default public ModerationService getModerationServiceInstance() {
        BaseService baseService = this;
        if (baseService instanceof ModerationService) {
            ModerationService moderationServiceInstance = (ModerationService)baseService;
            return moderationServiceInstance;
        }
        throw new ModuleException("Moderation Service not found", (ErrorTypeDefinition)InferenceErrorType.TOXICITY_DETECTION_OPERATION_FAILURE);
    }
}

