/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.proxy.HttpProxyConfig;
import com.mulesoft.connectors.inference.internal.utils.ObjectMapperProvider;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConnectionProvider
implements Initialisable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(BaseConnectionProvider.class);
    @RefName
    private String configName;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Proxy", order=3)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Proxy Configuration")
    private HttpProxyConfig proxyConfig;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Security", order=1)
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @DisplayName(value="TLS Configuration")
    @Summary(value="If the HTTPS was configured as protocol, then the user needs to configure at least the keystore configuration")
    private TlsContextFactory tlsContextFactory;
    @Inject
    private HttpService httpService;
    private HttpClient httpClient;
    private ObjectMapper objectMapper;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
        logger.debug("Starting httpClient...");
        this.httpClient = this.httpService.getClientFactory().create(this.createClientConfiguration());
        this.httpClient.start();
        this.objectMapper = ObjectMapperProvider.create();
    }

    public void dispose() {
        logger.debug("Stopping httpClient...");
        Optional.ofNullable(this.httpClient).ifPresent(HttpClient::stop);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HttpProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    private HttpClientConfiguration createClientConfiguration() {
        return new HttpClientConfiguration.Builder().setName(this.configName).setTlsContextFactory(this.tlsContextFactory).setProxyConfig((ProxyConfig)this.proxyConfig).build();
    }
}

