/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider;

import com.mulesoft.connectors.inference.api.metadata.ImageResponseAttributes;
import com.mulesoft.connectors.inference.api.response.ImageGenerationResponse;
import com.mulesoft.connectors.inference.internal.connection.provider.BaseConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.ImageGenerationConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageGenerationConnectionProvider
extends BaseConnectionProvider
implements CachedConnectionProvider<ImageGenerationConnection>,
Initialisable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(ImageGenerationConnectionProvider.class);

    public ConnectionValidationResult validate(ImageGenerationConnection connection) {
        logger.debug("Validating ImageGenerationConnection... ");
        try {
            Result<InputStream, ImageResponseAttributes> resp = connection.getImageGenerationService().executeGenerateImage(connection, "Generate a picture of a penguin dancing.");
            ImageGenerationResponse imageGenerationResponse = (ImageGenerationResponse)this.getObjectMapper().readValue((InputStream)resp.getOutput(), ImageGenerationResponse.class);
            if (StringUtils.isNotBlank((CharSequence)imageGenerationResponse.response())) {
                return ConnectionValidationResult.success();
            }
        }
        catch (IOException | TimeoutException | ModuleException e) {
            return ConnectionValidationResult.failure((String)"Failed to validate ImageGenerationConnection", (Exception)((Object)new ModuleException("Error validating connection.", (ErrorTypeDefinition)InferenceErrorType.INVALID_CONNECTION, e)));
        }
        return ConnectionValidationResult.failure((String)"Failed to validate ImageGenerationConnection", (Exception)((Object)new ModuleException("Error validating connection.", (ErrorTypeDefinition)InferenceErrorType.INVALID_CONNECTION)));
    }

    public void disconnect(ImageGenerationConnection imageGenerationConnection) {
        logger.debug(" ImageGenerationConnection disconnected ...");
    }
}

