/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider;

import com.mulesoft.connectors.inference.api.response.ModerationResponse;
import com.mulesoft.connectors.inference.internal.connection.provider.BaseConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.ModerationConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModerationConnectionProvider
extends BaseConnectionProvider
implements CachedConnectionProvider<ModerationConnection>,
Initialisable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(ModerationConnectionProvider.class);

    public ConnectionValidationResult validate(ModerationConnection connection) {
        logger.debug("Validating ModerationConnection... ");
        try {
            Result<InputStream, Void> resp = connection.getModerationService().executeTextModeration(connection, IOUtils.toInputStream((String)"\"You are fat\"", (Charset)Charset.defaultCharset()));
            ModerationResponse moderationResponse = (ModerationResponse)this.getObjectMapper().readValue((InputStream)resp.getOutput(), ModerationResponse.class);
            if (moderationResponse.flagged()) {
                return ConnectionValidationResult.success();
            }
        }
        catch (IOException | TimeoutException | ModuleException e) {
            return ConnectionValidationResult.failure((String)"Failed to validate ModerationConnection", (Exception)((Object)new ModuleException("Error validating connection.", (ErrorTypeDefinition)InferenceErrorType.INVALID_CONNECTION, e)));
        }
        return ConnectionValidationResult.failure((String)"Failed to validate ModerationConnection", (Exception)((Object)new ModuleException("Error validating connection.", (ErrorTypeDefinition)InferenceErrorType.INVALID_CONNECTION)));
    }

    public void disconnect(ModerationConnection connection) {
        logger.debug(" ModerationConnection disconnected ...");
    }
}

