/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.heroku;

import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.heroku.HerokuTextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.heroku.providers.HerokuTextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="heroku")
@DisplayName(value="Heroku AI")
public class HerokuTextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(HerokuTextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=HerokuTextGenerationModelNameProvider.class)
    @Optional(defaultValue="claude-3-7-sonnet")
    private String herokuInferenceModel;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(order=2)
    @Optional(defaultValue="https://us.inference.heroku.com")
    @DisplayName(value="Heroku Inference URL")
    private String herokuInferenceUrl;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters herokuTextGenerationConnectionParameters;

    public HerokuTextGenerationConnection connect() throws ConnectionException {
        logger.debug("HerokuTextGenerationConnection connect ...");
        return new HerokuTextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.herokuInferenceModel, this.herokuTextGenerationConnectionParameters.getApiKey(), this.herokuTextGenerationConnectionParameters.getMaxTokens(), this.herokuTextGenerationConnectionParameters.getTemperature(), this.herokuTextGenerationConnectionParameters.getTopP(), this.herokuTextGenerationConnectionParameters.getTimeout()), this.herokuInferenceUrl);
    }
}

