/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.openai;

import com.mulesoft.connectors.inference.internal.connection.parameters.VisionConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.VisionModelConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.openai.OpenAIVisionConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.openai.providers.OpenAIVisionModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="openai-vision")
@DisplayName(value="OpenAI")
public class OpenAIVisionConnectionProvider
extends VisionModelConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenAIVisionConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=OpenAIVisionModelNameProvider.class)
    private String openAIModelName;
    @ParameterGroup(name="Connection")
    private VisionConnectionParameters visionConnectionParameters;

    public OpenAIVisionConnection connect() throws ConnectionException {
        logger.debug("OpenAIVisionConnection connect ...");
        return new OpenAIVisionConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.openAIModelName, this.visionConnectionParameters.getApiKey(), this.visionConnectionParameters.getMaxTokens(), this.visionConnectionParameters.getTemperature(), this.visionConnectionParameters.getTopP(), this.visionConnectionParameters.getTimeout()));
    }
}

