/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.BaseConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.service.TextGenerationService;
import org.mule.runtime.http.api.client.HttpClient;

public abstract class TextGenerationConnection
extends BaseConnection {
    private final Number maxTokens;
    private final Number temperature;
    private final Number topP;
    private TextGenerationService textGenerationService;

    protected TextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO, String apiURL) {
        super(httpClient, objectMapper, parametersDTO.modelName(), parametersDTO.apiKey(), parametersDTO.timeout(), apiURL);
        this.maxTokens = parametersDTO.maxTokens();
        this.temperature = parametersDTO.temperature();
        this.topP = parametersDTO.topP();
        this.setBaseService(this.getTextGenerationService());
    }

    public Number getMaxTokens() {
        return this.maxTokens;
    }

    public Number getTemperature() {
        return this.temperature;
    }

    public Number getTopP() {
        return this.topP;
    }

    public TextGenerationService getTextGenerationService() {
        if (this.textGenerationService == null) {
            this.textGenerationService = new TextGenerationService(this.getRequestPayloadHelper(), this.getHttpRequestHelper(), this.getResponseHelper(), this.getResponseMapper(), this.getObjectMapper());
        }
        return this.textGenerationService;
    }
}

