/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.azure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.helpers.payload.AzureOpenAIRequestPayloadHelper;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;

public class AzureOpenAITextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "/chat/completions?api-version=2024-10-21";
    public static final String AZURE_OPENAI_URL = "https://{resource-name}.openai.azure.com/openai/deployments/{deployment-id}";
    private AzureOpenAIRequestPayloadHelper requestPayloadHelper;
    private final String user;

    public AzureOpenAITextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO, String azureOpenaiResourceName, String azureOpenaiDeploymentId, String azureOpenaiUser) {
        super(httpClient, objectMapper, parametersDTO, AzureOpenAITextGenerationConnection.fetchApiURL(azureOpenaiResourceName, azureOpenaiDeploymentId));
        this.user = azureOpenaiUser;
    }

    @Override
    public AzureOpenAIRequestPayloadHelper getRequestPayloadHelper() {
        if (this.requestPayloadHelper == null) {
            this.requestPayloadHelper = new AzureOpenAIRequestPayloadHelper(this.getObjectMapper());
        }
        return this.requestPayloadHelper;
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        return Map.of("api-key", this.getApiKey());
    }

    private static String fetchApiURL(String openaiResourceName, String openaiDeploymentId) {
        String urlStr = "https://{resource-name}.openai.azure.com/openai/deployments/{deployment-id}/chat/completions?api-version=2024-10-21";
        urlStr = urlStr.replace("{resource-name}", openaiResourceName).replace("{deployment-id}", openaiDeploymentId);
        return urlStr;
    }

    public String getAzureOpenaiUser() {
        return this.user;
    }
}

