/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.huggingface;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import org.mule.runtime.http.api.client.HttpClient;

public class HuggingFaceTextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "/models/{model-name}/v1/chat/completions";
    public static final String HUGGINGFACE_URL = "https://router.huggingface.co/hf-inference";

    public HuggingFaceTextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO) {
        super(httpClient, objectMapper, parametersDTO, HuggingFaceTextGenerationConnection.fetchApiURL(parametersDTO.modelName()));
    }

    private static String fetchApiURL(String modelName) {
        String urlStr = "https://router.huggingface.co/hf-inference/models/{model-name}/v1/chat/completions";
        urlStr = urlStr.replace("{model-name}", modelName);
        return urlStr;
    }
}

