/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.request.ChatPayloadRecord;
import com.mulesoft.connectors.inference.api.request.FunctionDefinitionRecord;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.OllamaRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.vision.DefaultVisionRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.vision.OllamaMessageRecord;
import com.mulesoft.connectors.inference.internal.helpers.payload.RequestPayloadHelper;
import java.util.List;

public class OllamaRequestPayloadHelper
extends RequestPayloadHelper {
    public OllamaRequestPayloadHelper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public OllamaRequestPayloadRecord buildPayload(TextGenerationConnection connection, List<ChatPayloadRecord> messagesArray, List<FunctionDefinitionRecord> tools) {
        return new OllamaRequestPayloadRecord(connection.getModelName(), messagesArray, connection.getMaxTokens(), connection.getTemperature(), connection.getTopP(), false, tools);
    }

    @Override
    public DefaultVisionRequestPayloadRecord createRequestImageURL(VisionModelConnection connection, String prompt, String imageUrl) {
        return new DefaultVisionRequestPayloadRecord(connection.getModelName(), List.of(new OllamaMessageRecord("user", prompt, List.of(imageUrl))), connection.getMaxTokens(), connection.getTemperature(), connection.getTopP());
    }
}

